/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingFilters {
    public static final String INDEXINGFILTER_ORDER = "indexingfilter.order";
    public static final Logger LOG = LoggerFactory.getLogger(IndexingFilters.class);
    private IndexingFilter[] indexingFilters;

    public IndexingFilters(Configuration conf) {
        String order = conf.get(INDEXINGFILTER_ORDER);
        ObjectCache objectCache = ObjectCache.get(conf);
        this.indexingFilters = (IndexingFilter[])objectCache.getObject(IndexingFilter.class.getName());
        if (this.indexingFilters == null) {
            String[] orderedFilters = null;
            if (order != null && !order.trim().equals("")) {
                orderedFilters = order.split("\\s+");
            }
            try {
                IndexingFilter filter;
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(IndexingFilter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(IndexingFilter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, IndexingFilter> filterMap = new HashMap<String, IndexingFilter>();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    filter = (IndexingFilter)extension.getExtensionInstance();
                    LOG.info("Adding " + filter.getClass().getName());
                    if (filterMap.containsKey(filter.getClass().getName())) continue;
                    filterMap.put(filter.getClass().getName(), filter);
                }
                if (orderedFilters == null) {
                    objectCache.setObject(IndexingFilter.class.getName(), filterMap.values().toArray(new IndexingFilter[0]));
                } else {
                    ArrayList<IndexingFilter> filters = new ArrayList<IndexingFilter>();
                    for (int i = 0; i < orderedFilters.length; ++i) {
                        filter = (IndexingFilter)filterMap.get(orderedFilters[i]);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                    objectCache.setObject(IndexingFilter.class.getName(), filters.toArray(new IndexingFilter[filters.size()]));
                }
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            this.indexingFilters = (IndexingFilter[])objectCache.getObject(IndexingFilter.class.getName());
        }
    }

    public NutchDocument filter(NutchDocument doc, String url, WebPage page) throws IndexingException {
        for (IndexingFilter indexingFilter : this.indexingFilters) {
            if ((doc = indexingFilter.filter(doc, url, page)) != null) continue;
            return null;
        }
        return doc;
    }

    public Collection<WebPage.Field> getFields() {
        HashSet<WebPage.Field> columns = new HashSet<WebPage.Field>();
        for (IndexingFilter indexingFilter : this.indexingFilters) {
            Collection<WebPage.Field> fields = indexingFilter.getFields();
            if (fields == null) continue;
            columns.addAll(fields);
        }
        return columns;
    }
}

