/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilters;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.scoring.ScoringFilters;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.StringUtil;
import org.apache.nutch.util.TableUtil;

public class IndexUtil {
    private static final Log LOG = LogFactory.getLog(new Object(){}.getClass().getEnclosingClass());
    private IndexingFilters filters;
    private ScoringFilters scoringFilters;

    public IndexUtil(Configuration conf) {
        this.filters = new IndexingFilters(conf);
        this.scoringFilters = new ScoringFilters(conf);
    }

    public NutchDocument index(String key, WebPage page) {
        NutchDocument doc = new NutchDocument();
        doc.add("id", key);
        doc.add("digest", StringUtil.toHexString(page.getSignature()));
        if (page.getBatchId() != null) {
            doc.add("batchId", page.getBatchId().toString());
        }
        String url = TableUtil.unreverseUrl(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Indexing URL: " + url));
        }
        try {
            doc = this.filters.filter(doc, url, page);
        }
        catch (IndexingException e) {
            LOG.warn((Object)("Error indexing " + key + ": " + e));
            return null;
        }
        if (doc == null) {
            return null;
        }
        float boost = 1.0f;
        try {
            boost = this.scoringFilters.indexerScore(url, doc, page, boost);
        }
        catch (ScoringFilterException e) {
            LOG.warn((Object)("Error calculating score " + key + ": " + e));
            return null;
        }
        doc.setScore(boost);
        doc.add("boost", Float.toString(boost));
        return doc;
    }
}

