/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.indexer.IndexCleaningFilter;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCleaningFilters {
    public static final String IndexCleaningFilter_ORDER = "IndexCleaningFilterhbase.order";
    public static final Logger LOG = LoggerFactory.getLogger(IndexCleaningFilters.class);
    private IndexCleaningFilter[] indexcleaningFilters;

    public IndexCleaningFilters(Configuration conf) {
        String order = conf.get(IndexCleaningFilter_ORDER);
        ObjectCache objectCache = ObjectCache.get(conf);
        this.indexcleaningFilters = (IndexCleaningFilter[])objectCache.getObject(IndexCleaningFilter.class.getName());
        if (this.indexcleaningFilters == null) {
            String[] orderedFilters = null;
            if (order != null && !order.trim().equals("")) {
                orderedFilters = order.split("\\s+");
            }
            try {
                IndexCleaningFilter filter;
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(IndexCleaningFilter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(IndexCleaningFilter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, IndexCleaningFilter> filterMap = new HashMap<String, IndexCleaningFilter>();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    filter = (IndexCleaningFilter)extension.getExtensionInstance();
                    LOG.info("Adding " + filter.getClass().getName());
                    if (filterMap.containsKey(filter.getClass().getName())) continue;
                    filterMap.put(filter.getClass().getName(), filter);
                }
                if (orderedFilters == null) {
                    objectCache.setObject(IndexCleaningFilter.class.getName(), filterMap.values().toArray(new IndexCleaningFilter[0]));
                } else {
                    ArrayList<IndexCleaningFilter> filters = new ArrayList<IndexCleaningFilter>();
                    for (int i = 0; i < orderedFilters.length; ++i) {
                        filter = (IndexCleaningFilter)filterMap.get(orderedFilters[i]);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                    objectCache.setObject(IndexCleaningFilter.class.getName(), filters.toArray(new IndexCleaningFilter[filters.size()]));
                }
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            this.indexcleaningFilters = (IndexCleaningFilter[])objectCache.getObject(IndexCleaningFilter.class.getName());
        }
    }

    public boolean remove(String url, WebPage page) throws IndexingException {
        for (IndexCleaningFilter indexcleaningFilter : this.indexcleaningFilters) {
            if (!indexcleaningFilter.remove(url, page)) continue;
            return true;
        }
        return false;
    }

    public Collection<WebPage.Field> getFields() {
        HashSet<WebPage.Field> columns = new HashSet<WebPage.Field>();
        for (IndexCleaningFilter indexcleaningFilter : this.indexcleaningFilters) {
            Collection<WebPage.Field> fields = indexcleaningFilter.getFields();
            if (fields == null) continue;
            columns.addAll(fields);
        }
        return columns;
    }
}

