/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.host;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.avro.util.Utf8;
import org.apache.gora.mapreduce.GoraOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostInjectorJob
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(HostInjectorJob.class);
    private Configuration conf;
    private static final Set<Host.Field> FIELDS = new HashSet<Host.Field>();

    public HostInjectorJob() {
    }

    public HostInjectorJob(Configuration conf) {
        this.setConf(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public boolean inject(Path hostDir) throws Exception {
        LOG.info("HostInjectorJob: starting");
        LOG.info("HostInjectorJob: hostDir: " + hostDir);
        NutchJob job = new NutchJob(this.getConf(), "inject-hosts " + hostDir);
        FileInputFormat.addInputPath((Job)job, (Path)hostDir);
        job.setMapperClass(UrlMapper.class);
        job.setMapOutputKeyClass(String.class);
        job.setMapOutputValueClass(Host.class);
        job.setOutputFormatClass(GoraOutputFormat.class);
        GoraOutputFormat.setOutput((Job)job, StorageUtils.createWebStore(job.getConfiguration(), String.class, Host.class), (boolean)true);
        job.setReducerClass(Reducer.class);
        job.setNumReduceTasks(0);
        return job.waitForCompletion(true);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: HostInjectorJob <host_dir>");
            return -1;
        }
        try {
            boolean success = this.inject(new Path(args[0]));
            if (!success) {
                LOG.error("HostInjectorJob: failed ");
                return -1;
            }
            LOG.info("HostInjectorJob: finished");
            return 0;
        }
        catch (Exception e) {
            LOG.error("HostInjectorJob: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new HostInjectorJob(), (String[])args);
        System.exit(res);
    }

    static {
        FIELDS.add(Host.Field.METADATA);
    }

    public static class UrlMapper
    extends Mapper<LongWritable, Text, String, Host> {
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String url = value.toString().trim();
            if (url.trim().length() == 0) {
                return;
            }
            TreeMap<String, String> metadata = new TreeMap<String, String>();
            if (url.indexOf("\t") != -1) {
                String[] splits = url.split("\t");
                url = splits[0];
                for (int s = 1; s < splits.length; ++s) {
                    int indexEquals = splits[s].indexOf("=");
                    if (indexEquals == -1) continue;
                    String metaname = splits[s].substring(0, indexEquals).trim();
                    String metavalue = splits[s].substring(indexEquals + 1).trim();
                    metadata.put(metaname, metavalue);
                }
            }
            Host host = new Host();
            for (String keymd : metadata.keySet()) {
                String valuemd = (String)metadata.get(keymd);
                host.getMetadata().put((CharSequence)new Utf8(keymd), ByteBuffer.wrap(valuemd.getBytes()));
            }
            String hostname = url.indexOf("://") > -1 ? new URL(url).getHost() : new URL("http://" + url).getHost();
            String hostkey = TableUtil.reverseHost(hostname);
            context.write((Object)hostkey, (Object)host);
        }
    }
}

