/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.host;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.gora.mapreduce.GoraReducer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.Histogram;
import org.apache.nutch.util.URLUtil;

public class HostDbUpdateReducer
extends GoraReducer<Text, WebPage, String, Host> {
    protected void reduce(Text key, Iterable<WebPage> values, Reducer.Context context) throws IOException, InterruptedException {
        int numPages = 0;
        int numFetched = 0;
        boolean buildLinkDb = true;
        Histogram<String> inlinkCount = new Histogram<String>();
        Histogram<String> outlinkCount = new Histogram<String>();
        for (WebPage page : values) {
            String host;
            ++numPages;
            if (page.getStatus() == 2) {
                ++numFetched;
            }
            if (!buildLinkDb) continue;
            if (page.getInlinks() != null) {
                Set<CharSequence> inlinks = page.getInlinks().keySet();
                for (CharSequence inlink : inlinks) {
                    host = URLUtil.getHost(inlink.toString());
                    inlinkCount.add(host);
                }
            }
            if (page.getOutlinks() == null) continue;
            Set<CharSequence> outlinks = page.getOutlinks().keySet();
            for (CharSequence outlink : outlinks) {
                host = URLUtil.getHost(outlink.toString());
                outlinkCount.add(host);
            }
        }
        Host host = new Host();
        host.getMetadata().put((CharSequence)new Utf8("p"), ByteBuffer.wrap(Integer.toString(numPages).getBytes()));
        if (numFetched > 0) {
            host.getMetadata().put((CharSequence)new Utf8("f"), ByteBuffer.wrap(Integer.toString(numFetched).getBytes()));
        }
        for (String inlink : inlinkCount.getKeys()) {
            host.getInlinks().put((CharSequence)new Utf8(inlink), (CharSequence)new Utf8(Integer.toString(inlinkCount.getCount(inlink))));
        }
        for (String outlink : outlinkCount.getKeys()) {
            host.getOutlinks().put((CharSequence)new Utf8(outlink), (CharSequence)new Utf8(Integer.toString(outlinkCount.getCount(outlink))));
        }
        context.write((Object)key.toString(), (Object)host);
    }
}

