/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.host;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.gora.mapreduce.GoraMapper;
import org.apache.gora.mapreduce.GoraReducer;
import org.apache.gora.query.Query;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.host.HostDbUpdateReducer;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDbUpdateJob
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(HostDbUpdateJob.class);
    private static final Collection<WebPage.Field> FIELDS = new HashSet<WebPage.Field>();
    private Configuration conf;

    public HostDbUpdateJob() {
    }

    public HostDbUpdateJob(Configuration conf) {
        this.setConf(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void updateHosts(boolean buildLinkDb) throws Exception {
        if (buildLinkDb) {
            FIELDS.add(WebPage.Field.INLINKS);
            FIELDS.add(WebPage.Field.OUTLINKS);
        }
        NutchJob job = new NutchJob(this.getConf(), "hostdb-update");
        DataStore<String, WebPage> pageStore = StorageUtils.createWebStore(job.getConfiguration(), String.class, WebPage.class);
        Query query = pageStore.newQuery();
        query.setFields(StorageUtils.toStringArray(FIELDS));
        GoraMapper.initMapperJob((Job)job, (Query)query, pageStore, Text.class, WebPage.class, Mapper.class, null, (boolean)true);
        DataStore<String, Host> hostStore = StorageUtils.createWebStore(job.getConfiguration(), String.class, Host.class);
        GoraReducer.initReducerJob((Job)job, hostStore, HostDbUpdateReducer.class);
        job.waitForCompletion(true);
    }

    public int run(String[] args) throws Exception {
        boolean linkDb = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-linkDb".equals(args[i])) {
                linkDb = true;
                continue;
            }
            if ("-crawlId".equals(args[i])) {
                this.getConf().set("storage.crawl.id", args[++i]);
                continue;
            }
            throw new IllegalArgumentException("unrecognized arg " + args[i] + " usage: (-linkDb) (-crawlId <crawlId>)");
        }
        LOG.info("Updating HostDb. Adding links:" + linkDb);
        this.updateHosts(linkDb);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new HostDbUpdateJob(), (String[])args);
        System.exit(res);
    }

    static {
        FIELDS.add(WebPage.Field.STATUS);
    }

    public static class Mapper
    extends GoraMapper<String, WebPage, Text, WebPage> {
        protected void map(String key, WebPage value, Mapper.Context context) throws IOException, InterruptedException {
            String reversedHost = TableUtil.getReversedHost(key);
            context.write((Object)new Text(reversedHost), (Object)value);
        }
    }
}

