/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.host;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.TableUtil;

public class HostDbReader
extends Configured
implements Tool {
    public static final Log LOG = LogFactory.getLog(HostDbReader.class);

    private void read(String key) throws ClassNotFoundException, IOException, Exception {
        DataStore<String, Host> datastore = StorageUtils.createWebStore(this.getConf(), String.class, Host.class);
        Query query = datastore.newQuery();
        if (key != null) {
            query.setKey((Object)TableUtil.reverseUrl(key));
        }
        Result result = datastore.execute(query);
        while (result.next()) {
            try {
                String hostName = TableUtil.unreverseUrl((String)result.getKey());
                Host host = (Host)result.get();
                System.out.println(hostName);
                System.out.println((Object)host);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result.close();
        datastore.close();
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new HostDbReader(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length > 1) {
            System.err.println("Usage: HostDBReader [key]");
            return -1;
        }
        try {
            String key = null;
            if (args.length == 1) {
                key = args[0];
            }
            this.read(key);
            return 0;
        }
        catch (Exception e) {
            LOG.fatal((Object)("HostDBReader: " + StringUtils.stringifyException((Throwable)e)));
            return -1;
        }
    }
}

