/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.host;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.util.TableUtil;

public class HostDb
implements Closeable {
    public static final Log LOG = LogFactory.getLog(HostDb.class);
    private static final CacheHost NULL_HOST = new CacheHost(null, 0L);
    private DataStore<String, Host> hostStore;
    public static final String HOSTDB_LRU_SIZE = "hostdb.lru.size";
    public static final int DEFAULT_LRU_SIZE = 100;
    public static final String HOSTDB_CONCURRENCY_LEVEL = "hostdb.concurrency.level";
    public static final int DEFAULT_HOSTDB_CONCURRENCY_LEVEL = 8;
    private Cache<String, CacheHost> cache;
    private AtomicLong lastFlush;

    public HostDb(Configuration conf) throws GoraException {
        try {
            this.hostStore = StorageUtils.createWebStore(conf, String.class, Host.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        long lruSize = conf.getLong(HOSTDB_LRU_SIZE, 100L);
        int concurrencyLevel = conf.getInt(HOSTDB_CONCURRENCY_LEVEL, 8);
        RemovalListener<String, CacheHost> listener = new RemovalListener<String, CacheHost>(){

            public void onRemoval(RemovalNotification<String, CacheHost> notification) {
                CacheHost removeFromCacheHost = (CacheHost)notification.getValue();
                if (removeFromCacheHost != NULL_HOST && removeFromCacheHost.timestamp < HostDb.this.lastFlush.get()) {
                    try {
                        HostDb.this.hostStore.flush();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    HostDb.this.lastFlush.set(System.currentTimeMillis());
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(lruSize).removalListener((RemovalListener)listener).concurrencyLevel(concurrencyLevel).build();
        this.lastFlush = new AtomicLong(System.currentTimeMillis());
    }

    public Host get(final String key) throws IOException {
        CacheHost cachedHost;
        Callable<CacheHost> valueLoader = new Callable<CacheHost>(){

            @Override
            public CacheHost call() throws Exception {
                Host host = (Host)HostDb.this.hostStore.get((Object)key);
                if (host == null) {
                    return NULL_HOST;
                }
                return new CacheHost(host, System.currentTimeMillis());
            }
        };
        try {
            cachedHost = (CacheHost)this.cache.get((Object)key, (Callable)valueLoader);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (cachedHost != NULL_HOST) {
            return cachedHost.host;
        }
        return null;
    }

    public Host getByHostName(String hostName) throws IOException {
        return this.get(TableUtil.reverseHost(hostName));
    }

    public void put(String key, Host host) throws IOException {
        this.cache.put((Object)key, (Object)new CacheHost(host, System.currentTimeMillis()));
        this.hostStore.put((Object)key, (Persistent)host);
    }

    @Override
    public void close() throws IOException {
        this.hostStore.close();
    }

    private static final class CacheHost {
        private final Host host;
        private final long timestamp;

        public CacheHost(Host host, long timestamp) {
            this.host = host;
            this.timestamp = timestamp;
        }
    }
}

