/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.nutch.crawl.NutchWritable;

public final class UrlWithScore
implements WritableComparable<UrlWithScore> {
    private static final Comparator<UrlWithScore> comp = new UrlScoreComparator();
    private Text url;
    private FloatWritable score;

    public UrlWithScore() {
        this.url = new Text();
        this.score = new FloatWritable();
    }

    public UrlWithScore(Text url, FloatWritable score) {
        this.url = url;
        this.score = score;
    }

    public UrlWithScore(String url, float score) {
        this.url = new Text(url);
        this.score = new FloatWritable(score);
    }

    public void write(DataOutput out) throws IOException {
        this.url.write(out);
        this.score.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.url.readFields(in);
        this.score.readFields(in);
    }

    public Text getUrl() {
        return this.url;
    }

    public void setUrl(Text url) {
        this.url = url;
    }

    public void setUrl(String url) {
        this.url.set(url);
    }

    public FloatWritable getScore() {
        return this.score;
    }

    public void setScore(FloatWritable score) {
        this.score = score;
    }

    public void setScore(float score) {
        this.score.set(score);
    }

    public int compareTo(UrlWithScore other) {
        return comp.compare(this, other);
    }

    public String toString() {
        return "UrlWithScore [url=" + this.url + ", score=" + this.score + "]";
    }

    public static final class UrlScoreComparator
    implements RawComparator<UrlWithScore> {
        private final WritableComparator textComp = new Text.Comparator();
        private final WritableComparator floatComp = new FloatWritable.Comparator();

        public int compare(UrlWithScore o1, UrlWithScore o2) {
            int cmp = o1.getUrl().compareTo((BinaryComparable)o2.getUrl());
            if (cmp != 0) {
                return cmp;
            }
            return -o1.getScore().compareTo((Object)o2.getScore());
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int deptLen1 = WritableUtils.decodeVIntSize((byte)b1[s1]) + WritableComparator.readVInt((byte[])b1, (int)s1);
                int deptLen2 = WritableUtils.decodeVIntSize((byte)b2[s2]) + WritableComparator.readVInt((byte[])b2, (int)s2);
                int cmp = this.textComp.compare(b1, s1, deptLen1, b2, s2, deptLen2);
                if (cmp != 0) {
                    return cmp;
                }
                return -this.floatComp.compare(b1, s1 + deptLen1, l1 - deptLen1, b2, s2 + deptLen2, l2 - deptLen2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static final class UrlOnlyComparator
        implements RawComparator<UrlWithScore> {
            private final WritableComparator textComp = new Text.Comparator();

            public int compare(UrlWithScore o1, UrlWithScore o2) {
                return o1.getUrl().compareTo((BinaryComparable)o2.getUrl());
            }

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                try {
                    int deptLen1 = WritableUtils.decodeVIntSize((byte)b1[s1]) + WritableComparator.readVInt((byte[])b1, (int)s1);
                    int deptLen2 = WritableUtils.decodeVIntSize((byte)b2[s2]) + WritableComparator.readVInt((byte[])b2, (int)s2);
                    return this.textComp.compare(b1, s1, deptLen1, b2, s2, deptLen2);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public static final class UrlOnlyPartitioner
    extends Partitioner<UrlWithScore, NutchWritable> {
        public int getPartition(UrlWithScore key, NutchWritable val, int reduces) {
            return (key.url.hashCode() & Integer.MAX_VALUE) % reduces;
        }
    }
}

