/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.nutch.crawl.GeneratorJob;
import org.apache.nutch.fetcher.FetchEntry;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.TableUtil;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPartitioner
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(URLPartitioner.class);
    public static final String PARTITION_MODE_KEY = "partition.url.mode";
    public static final String PARTITION_MODE_HOST = "byHost";
    public static final String PARTITION_MODE_DOMAIN = "byDomain";
    public static final String PARTITION_MODE_IP = "byIP";
    public static final String PARTITION_URL_SEED = "partition.url.seed";
    private Configuration conf;
    private int seed;
    private URLNormalizers normalizers;
    private String mode = "byHost";

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.seed = conf.getInt(PARTITION_URL_SEED, 0);
        this.mode = conf.get(PARTITION_MODE_KEY, PARTITION_MODE_HOST);
        if (!(this.mode.equals(PARTITION_MODE_IP) || this.mode.equals(PARTITION_MODE_DOMAIN) || this.mode.equals(PARTITION_MODE_HOST))) {
            LOG.error("Unknown partition mode : " + this.mode + " - forcing to byHost");
            this.mode = PARTITION_MODE_HOST;
        }
        this.normalizers = new URLNormalizers(conf, "partition");
    }

    public int getPartition(String urlString, int numReduceTasks) {
        int hashCode;
        if (numReduceTasks == 1) {
            return 0;
        }
        URL url = null;
        try {
            urlString = this.normalizers.normalize(urlString, "partition");
            hashCode = urlString.hashCode();
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.warn("Malformed URL: '" + urlString + "'");
            hashCode = urlString.hashCode();
        }
        if (url != null) {
            if (this.mode.equals(PARTITION_MODE_HOST)) {
                hashCode = url.getHost().hashCode();
            } else if (this.mode.equals(PARTITION_MODE_DOMAIN)) {
                hashCode = URLUtil.getDomainName(url).hashCode();
            } else {
                try {
                    InetAddress address = InetAddress.getByName(url.getHost());
                    hashCode = address.getHostAddress().hashCode();
                }
                catch (UnknownHostException e) {
                    GeneratorJob.LOG.info("Couldn't find IP for host: " + url.getHost());
                }
            }
        }
        return ((hashCode ^= this.seed) & Integer.MAX_VALUE) % numReduceTasks;
    }

    public static class FetchEntryPartitioner
    extends Partitioner<IntWritable, FetchEntry>
    implements Configurable {
        private URLPartitioner partitioner = new URLPartitioner();
        private Configuration conf;

        public int getPartition(IntWritable intWritable, FetchEntry fetchEntry, int numReduces) {
            String key = fetchEntry.getKey();
            String url = TableUtil.unreverseUrl(key);
            return this.partitioner.getPartition(url, numReduces);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
            this.partitioner.setConf(conf);
        }
    }

    public static class SelectorEntryPartitioner
    extends Partitioner<GeneratorJob.SelectorEntry, WebPage>
    implements Configurable {
        private URLPartitioner partitioner = new URLPartitioner();
        private Configuration conf;

        public int getPartition(GeneratorJob.SelectorEntry selectorEntry, WebPage page, int numReduces) {
            return this.partitioner.getPartition(selectorEntry.url, numReduces);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
            this.partitioner.setConf(conf);
        }
    }
}

