/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.io.MD5Hash;
import org.apache.nutch.crawl.MD5Signature;
import org.apache.nutch.crawl.Signature;
import org.apache.nutch.storage.WebPage;

public class TextMD5Signature
extends Signature {
    private static final Collection<WebPage.Field> FIELDS = new HashSet<WebPage.Field>();
    Signature fallback = new MD5Signature();

    @Override
    public byte[] calculate(WebPage page) {
        CharSequence text = page.getText();
        if (text == null || text.length() == 0) {
            return this.fallback.calculate(page);
        }
        return MD5Hash.digest((String)text.toString()).getDigest();
    }

    @Override
    public Collection<WebPage.Field> getFields() {
        HashSet<WebPage.Field> fields = new HashSet<WebPage.Field>(FIELDS);
        fields.addAll(this.fallback.getFields());
        return fields;
    }

    static {
        FIELDS.add(WebPage.Field.TEXT);
    }
}

