/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.MD5Signature;
import org.apache.nutch.crawl.Signature;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFactory.class);

    private SignatureFactory() {
    }

    public static Signature getSignature(Configuration conf) {
        String clazz = conf.get("db.signature.class", MD5Signature.class.getName());
        ObjectCache objectCache = ObjectCache.get(conf);
        Signature impl = (Signature)((Object)objectCache.getObject(clazz));
        if (impl == null) {
            try {
                LOG.info("Using Signature impl: " + clazz);
                Class<?> implClass = Class.forName(clazz);
                impl = (Signature)((Object)implClass.newInstance());
                impl.setConf(conf);
                objectCache.setObject(clazz, (Object)impl);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create " + clazz, e);
            }
        }
        return impl;
    }

    public static Collection<WebPage.Field> getFields(Configuration conf) {
        Signature impl = SignatureFactory.getSignature(conf);
        return impl.getFields();
    }
}

