/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.io.MD5Hash;
import org.apache.nutch.crawl.Signature;
import org.apache.nutch.storage.WebPage;

public class MD5Signature
extends Signature {
    private static final Collection<WebPage.Field> FIELDS = new HashSet<WebPage.Field>();

    @Override
    public byte[] calculate(WebPage page) {
        int cb;
        int of;
        byte[] data;
        ByteBuffer buf = page.getContent();
        if (buf == null) {
            Utf8 baseUrl = (Utf8)page.getBaseUrl();
            if (baseUrl == null) {
                data = null;
                of = 0;
                cb = 0;
            } else {
                data = baseUrl.getBytes();
                of = 0;
                cb = baseUrl.length();
            }
        } else {
            data = buf.array();
            of = buf.arrayOffset() + buf.position();
            cb = buf.remaining();
        }
        return MD5Hash.digest((byte[])data, (int)of, (int)cb).getDigest();
    }

    @Override
    public Collection<WebPage.Field> getFields() {
        return FIELDS;
    }

    static {
        FIELDS.add(WebPage.Field.CONTENT);
    }
}

