/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.gora.mapreduce.GoraMapper;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.crawl.DbUpdaterJob;
import org.apache.nutch.crawl.NutchWritable;
import org.apache.nutch.crawl.UrlWithScore;
import org.apache.nutch.scoring.ScoreDatum;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.scoring.ScoringFilters;
import org.apache.nutch.storage.Mark;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.TableUtil;
import org.apache.nutch.util.WebPageWritable;
import org.slf4j.Logger;

public class DbUpdateMapper
extends GoraMapper<String, WebPage, UrlWithScore, NutchWritable> {
    public static final Logger LOG = DbUpdaterJob.LOG;
    private ScoringFilters scoringFilters;
    private final List<ScoreDatum> scoreData = new ArrayList<ScoreDatum>();
    private Utf8 batchId;
    private UrlWithScore urlWithScore = new UrlWithScore();
    private NutchWritable nutchWritable = new NutchWritable();
    private WebPageWritable pageWritable;

    public void map(String key, WebPage page, Mapper.Context context) throws IOException, InterruptedException {
        if (Mark.GENERATE_MARK.checkMark(page) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping " + TableUtil.unreverseUrl(key) + "; not generated yet");
            }
            return;
        }
        String url = TableUtil.unreverseUrl(key);
        this.scoreData.clear();
        Map<CharSequence, CharSequence> outlinks = page.getOutlinks();
        if (outlinks != null) {
            for (Map.Entry<CharSequence, CharSequence> e : outlinks.entrySet()) {
                int depth = Integer.MAX_VALUE;
                CharSequence depthUtf8 = page.getMarkers().get(DbUpdaterJob.DISTANCE);
                if (depthUtf8 != null) {
                    depth = Integer.parseInt(depthUtf8.toString());
                }
                this.scoreData.add(new ScoreDatum(0.0f, e.getKey().toString(), e.getValue().toString(), depth));
            }
        }
        try {
            this.scoringFilters.distributeScoreToOutlinks(url, page, this.scoreData, outlinks == null ? 0 : outlinks.size());
        }
        catch (ScoringFilterException e) {
            LOG.warn("Distributing score failed for URL: " + key + " exception:" + StringUtils.stringifyException((Throwable)e));
        }
        this.urlWithScore.setUrl(key);
        this.urlWithScore.setScore(Float.MAX_VALUE);
        this.pageWritable.setWebPage(page);
        this.nutchWritable.set(this.pageWritable);
        context.write((Object)this.urlWithScore, (Object)this.nutchWritable);
        for (ScoreDatum scoreDatum : this.scoreData) {
            String reversedOut = TableUtil.reverseUrl(scoreDatum.getUrl());
            scoreDatum.setUrl(url);
            this.urlWithScore.setUrl(reversedOut);
            this.urlWithScore.setScore(scoreDatum.getScore());
            this.nutchWritable.set(scoreDatum);
            context.write((Object)this.urlWithScore, (Object)this.nutchWritable);
        }
    }

    public void setup(Mapper.Context context) {
        this.scoringFilters = new ScoringFilters(context.getConfiguration());
        this.pageWritable = new WebPageWritable(context.getConfiguration(), null);
        this.batchId = new Utf8(context.getConfiguration().get("nutch.batch.name", "-all"));
    }
}

