/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.AbstractFetchSchedule;
import org.apache.nutch.storage.WebPage;

public class AdaptiveFetchSchedule
extends AbstractFetchSchedule {
    private float INC_RATE;
    private float DEC_RATE;
    private int MAX_INTERVAL;
    private int MIN_INTERVAL;
    private boolean SYNC_DELTA;
    private double SYNC_DELTA_RATE;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.INC_RATE = conf.getFloat("db.fetch.schedule.adaptive.inc_rate", 0.2f);
        this.DEC_RATE = conf.getFloat("db.fetch.schedule.adaptive.dec_rate", 0.2f);
        this.MIN_INTERVAL = conf.getInt("db.fetch.schedule.adaptive.min_interval", 60);
        this.MAX_INTERVAL = conf.getInt("db.fetch.schedule.adaptive.max_interval", 31536000);
        this.SYNC_DELTA = conf.getBoolean("db.fetch.schedule.adaptive.sync_delta", true);
        this.SYNC_DELTA_RATE = conf.getFloat("db.fetch.schedule.adaptive.sync_delta_rate", 0.2f);
    }

    @Override
    public void setFetchSchedule(String url, WebPage page, long prevFetchTime, long prevModifiedTime, long fetchTime, long modifiedTime, int state) {
        super.setFetchSchedule(url, page, prevFetchTime, prevModifiedTime, fetchTime, modifiedTime, state);
        long refTime = fetchTime;
        if (modifiedTime <= 0L) {
            modifiedTime = fetchTime;
        }
        int interval = page.getFetchInterval();
        switch (state) {
            case 1: {
                interval = (int)((float)interval * (1.0f - this.DEC_RATE));
                break;
            }
            case 2: {
                interval = (int)((float)interval * (1.0f + this.INC_RATE));
                break;
            }
        }
        if (this.SYNC_DELTA) {
            int delta = (int)((fetchTime - modifiedTime) / 1000L);
            if (delta > interval) {
                interval = delta;
            }
            refTime = fetchTime - Math.round((double)delta * this.SYNC_DELTA_RATE);
        }
        if (interval < this.MIN_INTERVAL) {
            interval = this.MIN_INTERVAL;
        }
        if (interval > this.MAX_INTERVAL) {
            interval = this.MAX_INTERVAL;
        }
        page.setFetchInterval(interval);
        page.setFetchTime(refTime + (long)interval * 1000L);
        page.setModifiedTime(modifiedTime);
        page.setPrevModifiedTime(prevModifiedTime);
    }
}

