/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.crawl.FetchSchedule;
import org.apache.nutch.storage.WebPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFetchSchedule
extends Configured
implements FetchSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFetchSchedule.class);
    protected int defaultInterval;
    protected int maxInterval;
    private static final Set<WebPage.Field> FIELDS = new HashSet<WebPage.Field>();

    public AbstractFetchSchedule() {
        super(null);
    }

    public AbstractFetchSchedule(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.defaultInterval = conf.getInt("db.fetch.interval.default", 0);
        this.maxInterval = conf.getInt("db.fetch.interval.max", 0);
        LOG.info("defaultInterval=" + this.defaultInterval);
        LOG.info("maxInterval=" + this.maxInterval);
    }

    @Override
    public void initializeSchedule(String url, WebPage page) {
        page.setFetchTime(System.currentTimeMillis());
        page.setFetchInterval(this.defaultInterval);
        page.setRetriesSinceFetch(0);
    }

    @Override
    public void setFetchSchedule(String url, WebPage page, long prevFetchTime, long prevModifiedTime, long fetchTime, long modifiedTime, int state) {
        page.setRetriesSinceFetch(0);
    }

    @Override
    public void setPageGoneSchedule(String url, WebPage page, long prevFetchTime, long prevModifiedTime, long fetchTime) {
        if ((float)page.getFetchInterval().intValue() * 1.5f < (float)this.maxInterval) {
            int newFetchInterval = (int)((float)page.getFetchInterval().intValue() * 1.5f);
            page.setFetchInterval(newFetchInterval);
        } else {
            page.setFetchInterval((int)((float)this.maxInterval * 0.9f));
        }
        page.setFetchTime(fetchTime + (long)page.getFetchInterval().intValue() * 1000L);
    }

    @Override
    public void setPageRetrySchedule(String url, WebPage page, long prevFetchTime, long prevModifiedTime, long fetchTime) {
        page.setFetchTime(fetchTime + 86400000L);
        page.setRetriesSinceFetch(page.getRetriesSinceFetch() + 1);
    }

    @Override
    public long calculateLastFetchTime(WebPage page) {
        return page.getFetchTime() - (long)page.getFetchInterval().intValue() * 1000L;
    }

    @Override
    public boolean shouldFetch(String url, WebPage page, long curTime) {
        long fetchTime = page.getFetchTime();
        if (fetchTime - curTime > (long)this.maxInterval * 1000L) {
            if (page.getFetchInterval() > this.maxInterval) {
                page.setFetchInterval(Math.round((float)this.maxInterval * 0.9f));
            }
            page.setFetchTime(curTime);
        }
        return fetchTime <= curTime;
    }

    @Override
    public void forceRefetch(String url, WebPage page, boolean asap) {
        if (page.getFetchInterval() > this.maxInterval) {
            page.setFetchInterval(Math.round((float)this.maxInterval * 0.9f));
        }
        page.setStatus(1);
        page.setRetriesSinceFetch(0);
        page.setModifiedTime(0L);
        if (asap) {
            page.setFetchTime(System.currentTimeMillis());
        }
    }

    public Set<WebPage.Field> getFields() {
        return FIELDS;
    }

    static {
        FIELDS.add(WebPage.Field.FETCH_TIME);
        FIELDS.add(WebPage.Field.RETRIES_SINCE_FETCH);
        FIELDS.add(WebPage.Field.FETCH_INTERVAL);
    }
}

