/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.resources;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.nutch.api.model.request.SeedList;
import org.apache.nutch.api.model.request.SeedUrl;
import org.apache.nutch.api.resources.AbstractResource;
import org.apache.nutch.api.resources.AdminResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/seed")
public class SeedResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    public String createSeedFile(SeedList seedList) {
        if (seedList == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Seed list cannot be empty!").build());
        }
        File seedFile = this.createSeedFile();
        BufferedWriter writer = this.getWriter(seedFile);
        Collection<SeedUrl> seedUrls = seedList.getSeedUrls();
        if (CollectionUtils.isNotEmpty(seedUrls)) {
            for (SeedUrl seedUrl : seedUrls) {
                this.writeUrl(writer, seedUrl);
            }
        }
        return seedFile.getParent();
    }

    private void writeUrl(BufferedWriter writer, SeedUrl seedUrl) {
        try {
            writer.write(seedUrl.getUrl());
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    private BufferedWriter getWriter(File seedFile) {
        try {
            return new BufferedWriter(new FileWriter(seedFile));
        }
        catch (FileNotFoundException e) {
            throw this.handleException(e);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    private File createSeedFile() {
        try {
            return File.createTempFile("seed", ".txt", Files.createTempDir());
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(Exception e) {
        log.error("Cannot create seed file!", (Throwable)e);
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Cannot create seed file!").build());
    }
}

