/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.resources;

import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.nutch.api.model.request.JobConfig;
import org.apache.nutch.api.model.response.JobInfo;
import org.apache.nutch.api.resources.AbstractResource;

@Path(value="/job")
public class JobResource
extends AbstractResource {
    @GET
    @Path(value="/")
    public Collection<JobInfo> getJobs(@QueryParam(value="crawlId") String crawlId) {
        return this.jobManager.list(crawlId, JobInfo.State.ANY);
    }

    @GET
    @Path(value="/{id}")
    public JobInfo getInfo(@PathParam(value="id") String id, @QueryParam(value="crawlId") String crawlId) {
        return this.jobManager.get(crawlId, id);
    }

    @GET
    @Path(value="/{id}/stop")
    public boolean stop(@PathParam(value="id") String id, @QueryParam(value="crawlId") String crawlId) {
        return this.jobManager.stop(crawlId, id);
    }

    @GET
    @Path(value="/{id}/abort")
    public boolean abort(@PathParam(value="id") String id, @QueryParam(value="crawlId") String crawlId) {
        return this.jobManager.abort(crawlId, id);
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    public String create(JobConfig config) {
        if (config == null) {
            this.throwBadRequestException("Job configuration is required!");
        }
        return this.jobManager.create(config);
    }
}

