/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.resources;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.nutch.api.impl.db.DbReader;
import org.apache.nutch.api.model.request.DbFilter;
import org.apache.nutch.api.model.response.DbQueryResult;
import org.apache.nutch.api.resources.AbstractResource;

@Path(value="/db")
public class DbResource
extends AbstractResource {
    private Map<String, DbReader> readers = new WeakHashMap<String, DbReader>();

    @POST
    @Consumes(value={"application/json"})
    public DbQueryResult runQuery(DbFilter filter) {
        if (filter == null) {
            this.throwBadRequestException("Filter cannot be null!");
        }
        DbQueryResult result = new DbQueryResult();
        Iterator<Map<String, Object>> iterator = this.getReader().runQuery(filter);
        while (iterator.hasNext()) {
            result.addValue(iterator.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbReader getReader() {
        String confId = "default";
        Map<String, DbReader> map = this.readers;
        synchronized (map) {
            if (!this.readers.containsKey(confId)) {
                this.readers.put(confId, new DbReader(this.configManager.get(confId), null));
            }
            return this.readers.get(confId);
        }
    }
}

