/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.resources;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.nutch.api.model.request.NutchConfig;
import org.apache.nutch.api.resources.AbstractResource;

@Path(value="/config")
public class ConfigResource
extends AbstractResource {
    public static final String DEFAULT = "default";

    @GET
    @Path(value="/")
    public Set<String> getConfigs() {
        return this.configManager.list();
    }

    @GET
    @Path(value="/{configId}")
    public Map<String, String> getConfig(@PathParam(value="configId") String configId) {
        return this.configManager.getAsMap(configId);
    }

    @GET
    @Path(value="/{configId}/{propertyId}")
    public String getProperty(@PathParam(value="configId") String configId, @PathParam(value="propertyId") String propertyId) {
        return this.configManager.getAsMap(configId).get(propertyId);
    }

    @DELETE
    @Path(value="/{configId}")
    public void deleteConfig(@PathParam(value="configId") String configId) {
        this.configManager.delete(configId);
    }

    @POST
    @Path(value="/{configId}")
    @Consumes(value={"application/json"})
    public String createConfig(NutchConfig newConfig) {
        if (newConfig == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Nutch configuration cannot be empty!").build());
        }
        return this.configManager.create(newConfig);
    }

    @PUT
    @Path(value="/{config}/{property}")
    public Response update(@PathParam(value="config") String config, @PathParam(value="property") String property, @FormParam(value="value") String value) {
        if (value == null) {
            this.throwBadRequestException("Missing property value!");
        }
        this.configManager.setProperty(config, property, value);
        return Response.ok().build();
    }
}

