/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.resources;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.nutch.api.model.response.JobInfo;
import org.apache.nutch.api.model.response.NutchStatus;
import org.apache.nutch.api.resources.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class AdminResource
extends AbstractResource {
    private static final int DELAY_SEC = 10;
    private static final long DELAY_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final Logger LOG = LoggerFactory.getLogger(AdminResource.class);

    @GET
    @Path(value="/")
    public NutchStatus getNutchStatus() {
        NutchStatus status = new NutchStatus();
        status.setStartDate(new Date(this.server.getStarted()));
        status.setConfiguration(this.configManager.list());
        status.setJobs(this.jobManager.list(null, JobInfo.State.ANY));
        status.setRunningJobs(this.jobManager.list(null, JobInfo.State.RUNNING));
        return status;
    }

    @GET
    @Path(value="/stop")
    public String stop(@QueryParam(value="force") boolean force) {
        if (!this.server.canStop(force)) {
            LOG.info("Command 'stop' denied due to unfinished jobs");
            return "Can't stop now. There are jobs running. Try force option.";
        }
        this.scheduleServerStop();
        return MessageFormat.format("Stopping in {0} seconds.", 10);
    }

    private void scheduleServerStop() {
        LOG.info("Server shutdown scheduled in {} seconds", (Object)10);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(DELAY_MILLIS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                AdminResource.this.server.stop(false);
                LOG.info("Service stopped.");
            }
        };
        thread.setDaemon(true);
        thread.start();
        LOG.info("Service shutting down...");
    }
}

