/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl.db;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.api.impl.db.DbIterator;
import org.apache.nutch.api.model.request.DbFilter;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.TableUtil;

public class DbReader {
    private DataStore<String, WebPage> store;

    public DbReader(Configuration conf, String crawlId) {
        conf = new Configuration(conf);
        if (crawlId != null) {
            conf.set("storage.crawl.id", crawlId);
        }
        try {
            this.store = StorageUtils.createWebStore(conf, String.class, WebPage.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create webstore!", e);
        }
    }

    public Iterator<Map<String, Object>> runQuery(DbFilter filter) {
        String startKey = filter.getStartKey();
        String endKey = filter.getEndKey();
        if (!filter.isKeysReversed()) {
            startKey = this.reverseKey(filter.getStartKey());
            endKey = this.reverseKey(filter.getEndKey());
        }
        Query query = this.store.newQuery();
        query.setFields(this.prepareFields(filter.getFields()));
        if (startKey != null) {
            query.setStartKey((Object)startKey);
            if (endKey != null) {
                query.setEndKey((Object)endKey);
            }
        }
        Result result = this.store.execute(query);
        return new DbIterator((Result<String, WebPage>)result, filter.getFields(), filter.getBatchId());
    }

    private String reverseKey(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        try {
            return TableUtil.reverseUrl(key);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Wrong url format!", e);
        }
    }

    private String[] prepareFields(Set<String> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return null;
        }
        fields.remove("url");
        return fields.toArray(new String[fields.size()]);
    }
}

