/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl.db;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.nutch.parse.ParseStatusUtils;
import org.apache.nutch.protocol.ProtocolStatusUtils;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.Bytes;
import org.apache.nutch.util.StringUtil;

public class DbPageConverter {
    public static Map<String, Object> convertPage(WebPage page, Set<String> fields) {
        HashMap result = Maps.newHashMap();
        for (Schema.Field field : DbPageConverter.filterFields(page, fields)) {
            Object value = DbPageConverter.convertField(page, field);
            if (value == null) continue;
            result.put(field.name(), value);
        }
        return result;
    }

    private static Object convertField(WebPage page, Schema.Field field) {
        int index = field.pos();
        if (index < 0) {
            return null;
        }
        Object value = page.get(index);
        if (value == null) {
            return null;
        }
        String fieldName = field.name();
        if (StringUtils.equals((String)fieldName, (String)"metadata")) {
            return DbPageConverter.getSimpleMetadata(page);
        }
        if (StringUtils.equals((String)fieldName, (String)"protocolStatus")) {
            return ProtocolStatusUtils.toString(page.getProtocolStatus());
        }
        if (StringUtils.equals((String)fieldName, (String)"parseStatus")) {
            return ParseStatusUtils.toString(page.getParseStatus());
        }
        if (StringUtils.equals((String)fieldName, (String)"signature")) {
            return StringUtil.toHexString(page.getSignature());
        }
        if (StringUtils.equals((String)fieldName, (String)"content")) {
            return Bytes.toStringBinary(page.getContent());
        }
        if (StringUtils.equals((String)fieldName, (String)"markers")) {
            return DbPageConverter.convertToStringsMap(page.getMarkers());
        }
        if (StringUtils.equals((String)fieldName, (String)"inlinks")) {
            return DbPageConverter.convertToStringsMap(page.getInlinks());
        }
        if (StringUtils.equals((String)fieldName, (String)"outlinks")) {
            return DbPageConverter.convertToStringsMap(page.getOutlinks());
        }
        if (value instanceof Utf8) {
            return value.toString();
        }
        if (value instanceof ByteBuffer) {
            return Bytes.toStringBinary((ByteBuffer)value);
        }
        return value;
    }

    private static Set<Schema.Field> filterFields(WebPage page, Set<String> queryFields) {
        List pageFields = page.getSchema().getFields();
        if (CollectionUtils.isEmpty(queryFields)) {
            return Sets.newHashSet((Iterable)pageFields);
        }
        LinkedHashSet filteredFields = Sets.newLinkedHashSet();
        for (Schema.Field field : pageFields) {
            if (!queryFields.contains(field.name())) continue;
            filteredFields.add(field);
        }
        return filteredFields;
    }

    private static Map<String, String> getSimpleMetadata(WebPage page) {
        Map<CharSequence, ByteBuffer> metadata = page.getMetadata();
        if (MapUtils.isEmpty(metadata)) {
            return Collections.emptyMap();
        }
        HashMap simpleMeta = Maps.newHashMap();
        for (CharSequence key : metadata.keySet()) {
            simpleMeta.put(key.toString(), Bytes.toStringBinary(metadata.get(key)));
        }
        return simpleMeta;
    }

    private static Map<String, String> convertToStringsMap(Map<?, ?> map) {
        HashMap res = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            res.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return res;
    }
}

