/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl.db;

import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.commons.collections.CollectionUtils;
import org.apache.gora.query.Result;
import org.apache.nutch.api.impl.db.DbPageConverter;
import org.apache.nutch.storage.Mark;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbIterator
extends UnmodifiableIterator<Map<String, Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(DbIterator.class);
    private Result<String, WebPage> result;
    private boolean hasNext;
    private String url;
    private WebPage page;
    private Utf8 batchId;
    private Set<String> commonFields;

    DbIterator(Result<String, WebPage> res, Set<String> fields, String batchId) {
        this.result = res;
        if (batchId != null) {
            this.batchId = new Utf8(batchId);
        }
        if (fields != null) {
            this.commonFields = Sets.newTreeSet(fields);
        }
        try {
            this.skipNonRelevant();
        }
        catch (Exception e) {
            LOG.error("Cannot create db iterator!", (Throwable)e);
        }
    }

    private void skipNonRelevant() throws Exception, IOException {
        this.hasNext = this.result.next();
        if (!this.hasNext) {
            return;
        }
        if (this.batchId == null) {
            return;
        }
        while (this.hasNext) {
            WebPage page = (WebPage)this.result.get();
            Utf8 mark = Mark.UPDATEDB_MARK.checkMark(page);
            if (NutchJob.shouldProcess((CharSequence)mark, this.batchId)) {
                return;
            }
            LOG.debug("Skipping {}; different batch id", this.result.getKey());
            this.hasNext = this.result.next();
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Map<String, Object> next() {
        this.url = (String)this.result.getKey();
        this.page = WebPage.newBuilder((WebPage)this.result.get()).build();
        try {
            this.skipNonRelevant();
            if (!this.hasNext) {
                this.result.close();
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get next result!", (Throwable)e);
            this.hasNext = false;
            return null;
        }
        return this.pageAsMap(this.url, this.page);
    }

    private Map<String, Object> pageAsMap(String url, WebPage page) {
        Map<String, Object> result = DbPageConverter.convertPage(page, this.commonFields);
        if (CollectionUtils.isEmpty(this.commonFields) || this.commonFields.contains("url")) {
            result.put("url", TableUtil.unreverseUrl(url));
        }
        return result;
    }
}

