/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.api.ConfManager;
import org.apache.nutch.api.JobManager;
import org.apache.nutch.api.impl.JobFactory;
import org.apache.nutch.api.impl.JobWorker;
import org.apache.nutch.api.impl.NutchServerPoolExecutor;
import org.apache.nutch.api.model.request.JobConfig;
import org.apache.nutch.api.model.response.JobInfo;
import org.apache.nutch.util.NutchTool;

public class RAMJobManager
implements JobManager {
    private JobFactory jobFactory;
    private NutchServerPoolExecutor executor;
    private ConfManager configManager;

    public RAMJobManager(JobFactory jobFactory, NutchServerPoolExecutor executor, ConfManager configManager) {
        this.jobFactory = jobFactory;
        this.executor = executor;
        this.configManager = configManager;
    }

    @Override
    public Collection<JobInfo> list(String crawlId, JobInfo.State state) {
        if (state == null || state == JobInfo.State.ANY) {
            return this.executor.getAllJobs();
        }
        if (state == JobInfo.State.RUNNING || state == JobInfo.State.IDLE) {
            return this.executor.getJobRunning();
        }
        return this.executor.getJobHistory();
    }

    @Override
    public JobInfo get(String crawlId, String jobId) {
        return this.executor.getInfo(jobId);
    }

    @Override
    public String create(JobConfig jobConfig) {
        if (jobConfig.getArgs() == null) {
            throw new IllegalArgumentException("Arguments cannot be null!");
        }
        Configuration conf = this.cloneConfiguration(jobConfig.getConfId());
        NutchTool tool = this.createTool(jobConfig, conf);
        JobWorker worker = new JobWorker(jobConfig, conf, tool);
        this.executor.execute(worker);
        this.executor.purge();
        return worker.getInfo().getId();
    }

    private Configuration cloneConfiguration(String confId) {
        Configuration conf = this.configManager.get(confId);
        if (conf == null) {
            throw new IllegalArgumentException("Unknown confId " + confId);
        }
        return new Configuration(conf);
    }

    private NutchTool createTool(JobConfig jobConfig, Configuration conf) {
        if (StringUtils.isNotBlank((String)jobConfig.getJobClassName())) {
            return this.jobFactory.createToolByClassName(jobConfig.getJobClassName(), conf);
        }
        return this.jobFactory.createToolByType(jobConfig.getType(), conf);
    }

    @Override
    public boolean abort(String crawlId, String id) {
        return this.executor.findWorker(id).killJob();
    }

    @Override
    public boolean stop(String crawlId, String id) {
        return this.executor.findWorker(id).stopJob();
    }
}

