/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.api.ConfManager;
import org.apache.nutch.api.model.request.NutchConfig;
import org.apache.nutch.util.NutchConfiguration;

public class RAMConfManager
implements ConfManager {
    private Map<String, Configuration> configurations = Maps.newConcurrentMap();
    private AtomicInteger newConfigId = new AtomicInteger();

    public RAMConfManager() {
        this.configurations.put("default", NutchConfiguration.create());
    }

    @Override
    public Set<String> list() {
        return this.configurations.keySet();
    }

    @Override
    public Configuration get(String confId) {
        if (confId == null) {
            return this.configurations.get("default");
        }
        return this.configurations.get(confId);
    }

    @Override
    public Map<String, String> getAsMap(String confId) {
        Configuration configuration = this.configurations.get(confId);
        if (configuration == null) {
            return Collections.emptyMap();
        }
        Iterator iterator = configuration.iterator();
        TreeMap configMap = Maps.newTreeMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            configMap.put(entry.getKey(), entry.getValue());
        }
        return configMap;
    }

    @Override
    public void setProperty(String confId, String propName, String propValue) {
        if (!this.configurations.containsKey(confId)) {
            throw new IllegalArgumentException("Unknown configId '" + confId + "'");
        }
        Configuration conf = this.configurations.get(confId);
        conf.set(propName, propValue);
    }

    @Override
    public void delete(String confId) {
        this.configurations.remove(confId);
    }

    @Override
    public String create(NutchConfig nutchConfig) {
        if (StringUtils.isBlank((String)nutchConfig.getConfigId())) {
            nutchConfig.setConfigId(String.valueOf(this.newConfigId.incrementAndGet()));
        }
        if (!this.canCreate(nutchConfig)) {
            throw new IllegalArgumentException("Config already exists.");
        }
        this.createHadoopConfig(nutchConfig);
        return nutchConfig.getConfigId();
    }

    private boolean canCreate(NutchConfig nutchConfig) {
        if (nutchConfig.isForce()) {
            return true;
        }
        return !this.configurations.containsKey(nutchConfig.getConfigId());
    }

    private void createHadoopConfig(NutchConfig nutchConfig) {
        Configuration conf = NutchConfiguration.create();
        this.configurations.put(nutchConfig.getConfigId(), conf);
        if (MapUtils.isEmpty(nutchConfig.getParams())) {
            return;
        }
        for (Map.Entry<String, String> e : nutchConfig.getParams().entrySet()) {
            conf.set(e.getKey(), e.getValue());
        }
    }
}

