/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.nutch.api.impl.JobWorker;
import org.apache.nutch.api.model.response.JobInfo;

public class NutchServerPoolExecutor
extends ThreadPoolExecutor {
    private Queue<JobWorker> workersHistory;
    private Queue<JobWorker> runningWorkers;

    public NutchServerPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.workersHistory = Queues.newArrayBlockingQueue((int)maximumPoolSize);
        this.runningWorkers = Queues.newArrayBlockingQueue((int)maximumPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        Queue<JobWorker> queue = this.runningWorkers;
        synchronized (queue) {
            this.runningWorkers.offer((JobWorker)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        Queue<JobWorker> queue = this.runningWorkers;
        synchronized (queue) {
            this.runningWorkers.remove(((JobWorker)runnable).getInfo());
        }
        JobWorker worker = (JobWorker)runnable;
        this.addStatusToHistory(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatusToHistory(JobWorker worker) {
        Queue<JobWorker> queue = this.workersHistory;
        synchronized (queue) {
            if (!this.workersHistory.offer(worker)) {
                this.workersHistory.poll();
                this.workersHistory.add(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobWorker findWorker(String jobId) {
        Queue<JobWorker> queue = this.runningWorkers;
        synchronized (queue) {
            for (JobWorker worker : this.runningWorkers) {
                if (!StringUtils.equals((String)worker.getInfo().getId(), (String)jobId)) continue;
                return worker;
            }
        }
        return null;
    }

    public Collection<JobInfo> getJobHistory() {
        return this.getJobsInfo(this.workersHistory);
    }

    public Collection<JobInfo> getJobRunning() {
        return this.getJobsInfo(this.runningWorkers);
    }

    public Collection<JobInfo> getAllJobs() {
        return CollectionUtils.union(this.getJobRunning(), this.getJobHistory());
    }

    private Collection<JobInfo> getJobsInfo(Collection<JobWorker> workers) {
        LinkedList jobsInfo = Lists.newLinkedList();
        for (JobWorker worker : workers) {
            jobsInfo.add(worker.getInfo());
        }
        return jobsInfo;
    }

    public JobInfo getInfo(String jobId) {
        for (JobInfo jobInfo : this.getAllJobs()) {
            if (!StringUtils.equals((String)jobId, (String)jobInfo.getId())) continue;
            return jobInfo;
        }
        return null;
    }
}

