/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl;

import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.api.model.request.JobConfig;
import org.apache.nutch.api.model.response.JobInfo;
import org.apache.nutch.util.NutchTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(JobWorker.class);
    private NutchTool tool;
    private JobInfo jobInfo;
    private JobConfig jobConfig;

    public JobWorker(JobConfig jobConfig, Configuration conf, NutchTool tool) {
        this.tool = tool;
        this.jobConfig = jobConfig;
        if (jobConfig.getConfId() == null) {
            jobConfig.setConfId("default");
        }
        this.jobInfo = new JobInfo(this.generateId(), jobConfig, JobInfo.State.IDLE, "idle");
        if (jobConfig.getCrawlId() != null) {
            conf.set("storage.crawl.id", jobConfig.getCrawlId());
        }
    }

    private String generateId() {
        if (this.jobConfig.getCrawlId() == null) {
            return MessageFormat.format("{0}-{1}-{2}", new Object[]{this.jobConfig.getConfId(), this.jobConfig.getType(), String.valueOf(this.hashCode())});
        }
        return MessageFormat.format("{0}-{1}-{2}-{3}", new Object[]{this.jobConfig.getCrawlId(), this.jobConfig.getConfId(), this.jobConfig.getType(), String.valueOf(this.hashCode())});
    }

    @Override
    public void run() {
        try {
            this.getInfo().setState(JobInfo.State.RUNNING);
            this.getInfo().setMsg("OK");
            this.getInfo().setResult(this.tool.run(this.getInfo().getArgs()));
            this.getInfo().setState(JobInfo.State.FINISHED);
        }
        catch (Exception e) {
            LOG.error("Cannot run job worker!", (Throwable)e);
            this.getInfo().setMsg("ERROR: " + e.toString());
            this.getInfo().setState(JobInfo.State.FAILED);
        }
    }

    public boolean stopJob() {
        this.getInfo().setState(JobInfo.State.STOPPING);
        try {
            return this.tool.stopJob();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot stop job with id " + this.getInfo().getId(), e);
        }
    }

    public boolean killJob() {
        this.getInfo().setState(JobInfo.State.KILLING);
        try {
            boolean result = this.tool.killJob();
            this.getInfo().setState(JobInfo.State.KILLED);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot kill job with id " + this.getInfo().getId(), e);
        }
    }

    public JobInfo getInfo() {
        return this.jobInfo;
    }

    public void setInfo(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }
}

