/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.nutch.api.JobManager;
import org.apache.nutch.crawl.DbUpdaterJob;
import org.apache.nutch.crawl.GeneratorJob;
import org.apache.nutch.crawl.InjectorJob;
import org.apache.nutch.crawl.WebTableReader;
import org.apache.nutch.fetcher.FetcherJob;
import org.apache.nutch.indexer.IndexingJob;
import org.apache.nutch.parse.ParserJob;
import org.apache.nutch.util.NutchTool;

public class JobFactory {
    private static Map<JobManager.JobType, Class<? extends NutchTool>> typeToClass = Maps.newHashMap();

    public NutchTool createToolByType(JobManager.JobType type, Configuration conf) {
        if (!typeToClass.containsKey((Object)type)) {
            return null;
        }
        Class<? extends NutchTool> clz = typeToClass.get((Object)type);
        return this.createTool(clz, conf);
    }

    public NutchTool createToolByClassName(String className, Configuration conf) {
        try {
            Class<?> clz = Class.forName(className);
            return this.createTool(clz, conf);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private NutchTool createTool(Class<? extends NutchTool> clz, Configuration conf) {
        return (NutchTool)((Object)ReflectionUtils.newInstance(clz, (Configuration)conf));
    }

    static {
        typeToClass.put(JobManager.JobType.FETCH, FetcherJob.class);
        typeToClass.put(JobManager.JobType.GENERATE, GeneratorJob.class);
        typeToClass.put(JobManager.JobType.INDEX, IndexingJob.class);
        typeToClass.put(JobManager.JobType.INJECT, InjectorJob.class);
        typeToClass.put(JobManager.JobType.PARSE, ParserJob.class);
        typeToClass.put(JobManager.JobType.UPDATEDB, DbUpdaterJob.class);
        typeToClass.put(JobManager.JobType.READDB, WebTableReader.class);
    }
}

