/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.api;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.ws.rs.core.Application;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.nutch.api.ConfManager;
import org.apache.nutch.api.JobManager;
import org.apache.nutch.api.impl.JobFactory;
import org.apache.nutch.api.impl.NutchServerPoolExecutor;
import org.apache.nutch.api.impl.RAMConfManager;
import org.apache.nutch.api.impl.RAMJobManager;
import org.apache.nutch.api.misc.ErrorStatusService;
import org.apache.nutch.api.model.response.JobInfo;
import org.apache.nutch.api.resources.AdminResource;
import org.apache.nutch.api.resources.ConfigResource;
import org.apache.nutch.api.resources.DbResource;
import org.apache.nutch.api.resources.JobResource;
import org.apache.nutch.api.resources.SeedResource;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.resource.ClientResource;
import org.restlet.service.StatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutchServer
extends Application {
    public static final String NUTCH_SERVER = "NUTCH_SERVER";
    private static final Logger LOG = LoggerFactory.getLogger(NutchServer.class);
    private static final String LOCALHOST = "localhost";
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final Integer DEFAULT_PORT = 8081;
    private static final int JOB_CAPACITY = 100;
    private static String logLevel = "INFO";
    private static Integer port = DEFAULT_PORT;
    private static final String CMD_HELP = "help";
    private static final String CMD_STOP = "stop";
    private static final String CMD_PORT = "port";
    private static final String CMD_LOG_LEVEL = "log";
    private Component component;
    private ConfManager configManager = new RAMConfManager();
    private JobManager jobMgr;
    private long started;
    private boolean running;

    public NutchServer() {
        ArrayBlockingQueue runnables = Queues.newArrayBlockingQueue((int)100);
        NutchServerPoolExecutor executor = new NutchServerPoolExecutor(10, 100, 1L, TimeUnit.HOURS, runnables);
        this.jobMgr = new RAMJobManager(new JobFactory(), executor, this.configManager);
        this.component = new Component();
        this.component.getLogger().setLevel(Level.parse(logLevel));
        this.component.getServers().add(Protocol.HTTP, port.intValue());
        Context childContext = this.component.getContext().createChildContext();
        JaxRsApplication application = new JaxRsApplication(childContext);
        application.add((Application)this);
        application.setStatusService((StatusService)new ErrorStatusService());
        childContext.getAttributes().put(NUTCH_SERVER, this);
        this.component.getDefaultHost().attach((Restlet)application);
    }

    public Set<Class<?>> getClasses() {
        HashSet resources = Sets.newHashSet();
        resources.add(JobResource.class);
        resources.add(AdminResource.class);
        resources.add(ConfigResource.class);
        resources.add(DbResource.class);
        resources.add(SeedResource.class);
        return resources;
    }

    public ConfManager getConfMgr() {
        return this.configManager;
    }

    public JobManager getJobMgr() {
        return this.jobMgr;
    }

    public long getStarted() {
        return this.started;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        LOG.info("Starting NutchServer on port: {} with logging level: {} ...", (Object)port, (Object)logLevel);
        try {
            this.component.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start server!", e);
        }
        LOG.info("Started NutchServer on port {}", (Object)port);
        this.running = true;
        this.started = System.currentTimeMillis();
    }

    public boolean canStop(boolean force) {
        if (force) {
            return true;
        }
        Collection<JobInfo> jobs = this.getJobMgr().list(null, JobInfo.State.RUNNING);
        return jobs.isEmpty();
    }

    public boolean stop(boolean force) {
        if (!this.running) {
            return true;
        }
        if (!this.canStop(force)) {
            LOG.warn("Running jobs - can't stop now.");
            return false;
        }
        LOG.info("Stopping NutchServer on port {}...", (Object)port);
        try {
            this.component.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot stop nutch server", e);
        }
        LOG.info("Stopped NutchServer on port {}", (Object)port);
        this.running = false;
        return true;
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = NutchServer.createOptions();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption(CMD_HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("NutchServer", options, true);
            return;
        }
        if (commandLine.hasOption(CMD_LOG_LEVEL)) {
            logLevel = commandLine.getOptionValue(CMD_LOG_LEVEL);
        }
        if (commandLine.hasOption(CMD_PORT)) {
            port = Integer.parseInt(commandLine.getOptionValue(CMD_PORT));
        }
        if (commandLine.hasOption(CMD_STOP)) {
            String stopParameter = commandLine.getOptionValue(CMD_STOP);
            boolean force = StringUtils.equals((String)"force", (String)stopParameter);
            NutchServer.stopRemoteServer(force);
            return;
        }
        NutchServer.startServer();
    }

    private static void startServer() {
        NutchServer server = new NutchServer();
        server.start();
    }

    private static void stopRemoteServer(boolean force) {
        Reference reference = new Reference(Protocol.HTTP, LOCALHOST, port.intValue());
        reference.setPath("/admin/stop");
        if (force) {
            reference.addQueryParameter("force", "true");
        }
        ClientResource clientResource = new ClientResource(reference);
        clientResource.get();
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"logging level");
        OptionBuilder.withDescription((String)"Select a logging level for the NutchServer: \nALL|CONFIG|FINER|FINEST|INFO|OFF|SEVERE|WARNING");
        options.addOption(OptionBuilder.create((String)CMD_LOG_LEVEL));
        OptionBuilder.withDescription((String)"Stop running NutchServer. true value forces the Server to stop despite running jobs e.g. kills the tasks ");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"force");
        options.addOption(OptionBuilder.create((String)CMD_STOP));
        OptionBuilder.withDescription((String)"Show this help");
        options.addOption(OptionBuilder.create((String)CMD_HELP));
        OptionBuilder.withDescription((String)"Port to use for restful API.");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"port number");
        options.addOption(OptionBuilder.create((String)CMD_PORT));
        return options;
    }
}

