/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.types;

import java.util.Comparator;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;

public class Pair<S, T>
implements Comparable<Pair<S, T>> {
    private final S first;
    private final T second;

    public Pair(S car, T cdr) {
        this.first = ArgumentChecker.returnNonNull(car);
        this.second = ArgumentChecker.returnNonNull(cdr);
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            return this.first.equals(p.first) && this.second.equals(p.second);
        }
        return false;
    }

    public int hashCode() {
        return this.first.hashCode() + (this.second.hashCode() << 1);
    }

    @Override
    public int compareTo(Pair<S, T> p) {
        int firstResult = ((Comparable)this.first).compareTo(p.first);
        if (firstResult == 0) {
            return ((Comparable)this.second).compareTo(p.second);
        }
        return firstResult;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public static class SecondElemComparator<S, T>
    implements Comparator<Pair<S, T>> {
        @Override
        public int compare(Pair<S, T> p1, Pair<S, T> p2) {
            return ((Comparable)((Pair)p1).second).compareTo(((Pair)p2).second);
        }
    }

    public static class FirstElemComparator<S, T>
    implements Comparator<Pair<S, T>> {
        @Override
        public int compare(Pair<S, T> p1, Pair<S, T> p2) {
            return ((Comparable)((Pair)p1).first).compareTo(((Pair)p2).first);
        }
    }
}

