/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mrunit.MapDriverBase;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.mapreduce.ContextDriver;
import org.apache.hadoop.mrunit.internal.mapreduce.MockMapContextWrapper;
import org.apache.hadoop.mrunit.internal.output.MockMultipleOutputs;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MultipleOutputs.class})
public class MapDriver<K1, V1, K2, V2>
extends MapDriverBase<K1, V1, K2, V2, MapDriver<K1, V1, K2, V2>>
implements ContextDriver {
    public static final Log LOG = LogFactory.getLog(MapDriver.class);
    private Mapper<K1, V1, K2, V2> myMapper;
    private Counters counters;
    private MockMapContextWrapper<K1, V1, K2, V2> wrapper;

    public MapDriver(Mapper<K1, V1, K2, V2> m) {
        this();
        this.setMapper(m);
    }

    public MapDriver() {
        this.setCounters(new Counters());
    }

    public void setMapper(Mapper<K1, V1, K2, V2> m) {
        this.myMapper = ArgumentChecker.returnNonNull(m);
    }

    public MapDriver<K1, V1, K2, V2> withMapper(Mapper<K1, V1, K2, V2> m) {
        this.setMapper(m);
        return this;
    }

    public Mapper<K1, V1, K2, V2> getMapper() {
        return this.myMapper;
    }

    @Override
    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(this.counters);
    }

    public MapDriver<K1, V1, K2, V2> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public MapDriver<K1, V1, K2, V2> withOutputFormat(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.mockOutputCreator.setMapreduceFormats(outputFormatClass, inputFormatClass);
        return this;
    }

    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        try {
            this.preRunChecks(this.myMapper);
            this.initDistributedCache();
            MockMapContextWrapper<K1, V1, K2, V2> wrapper = this.getContextWrapper();
            this.mos = new MockMultipleOutputs((TaskInputOutputContext)wrapper.getMockContext());
            try {
                PowerMockito.whenNew(MultipleOutputs.class).withArguments(wrapper.getMockContext(), new Object[0]).thenReturn((Object)this.mos);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.myMapper.run((Mapper.Context)wrapper.getMockContext());
            List list = wrapper.getOutputs();
            return list;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        finally {
            this.cleanupDistributedCache();
        }
    }

    public String toString() {
        return "MapDriver (0.20+) (" + this.myMapper + ")";
    }

    private MockMapContextWrapper<K1, V1, K2, V2> getContextWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new MockMapContextWrapper(this.getConfiguration(), this.inputs, this.mockOutputCreator, this);
        }
        return this.wrapper;
    }

    public Mapper.Context getContext() {
        return (Mapper.Context)this.getContextWrapper().getMockContext();
    }

    public static <K1, V1, K2, V2> MapDriver<K1, V1, K2, V2> newMapDriver() {
        return new MapDriver<K1, V1, K2, V2>();
    }

    public static <K1, V1, K2, V2> MapDriver<K1, V1, K2, V2> newMapDriver(Mapper<K1, V1, K2, V2> mapper) {
        return new MapDriver<K1, V1, K2, V2>(mapper);
    }
}

