/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.mrunit.internal.util.StringUtils;
import org.junit.Assert;

public class Errors {
    private final List<String> messages = new ArrayList<String>();
    private final Log log;

    public Errors(Log log) {
        this.log = log;
    }

    public void record(String message) {
        this.log.error((Object)message);
        this.messages.add(message);
    }

    public void record(String format, Object ... args) {
        String message = String.format(format, args);
        this.log.error((Object)message);
        this.messages.add(message);
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void assertNone() {
        if (!this.isEmpty()) {
            Assert.fail((String)this.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.messages.size()).append(" Error(s): ");
        StringUtils.formatValueList(this.messages, buffer);
        return buffer.toString();
    }
}

