/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.RunJar;

public class DistCacheUtils {
    private static final String CACHE_LOCALARCHIVES = "mapred.cache.localArchives";
    private static final String CACHE_LOCALFILES = "mapred.cache.localFiles";
    private static final Log LOG = LogFactory.getLog(DistCacheUtils.class);

    private DistCacheUtils() {
    }

    public static URI findResource(String path) {
        URI uri = null;
        try {
            URL resourceUrl = DistCacheUtils.class.getClassLoader().getResource(path);
            uri = resourceUrl != null ? resourceUrl.toURI() : new File(path).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path + " could not be found", e);
        }
        if (uri == null) {
            throw new IllegalArgumentException(path + " could not be found");
        }
        return uri;
    }

    public static String stringifyPathList(List<Path> p) {
        if (p == null || p.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder(p.get(0).toString());
        for (int i = 1; i < p.size(); ++i) {
            str.append(",");
            str.append(p.get(i).toString());
        }
        return str.toString();
    }

    public static File createTempDirectory() throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "mrunit-" + UUID.randomUUID().toString());
        LOG.debug((Object)("Creating temp directory " + tmpDir));
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static Path extractArchiveToTemp(Path cacheArchive, File tmpDir) throws IOException {
        String tmpArchive = cacheArchive.getName().toLowerCase();
        File srcFile = new File(cacheArchive.toString());
        File destDir = new File(tmpDir, srcFile.getName());
        LOG.debug((Object)String.format("Extracting %s to %s", srcFile.toString(), destDir.toString()));
        if (tmpArchive.endsWith(".jar")) {
            RunJar.unJar((File)srcFile, (File)destDir);
        } else if (tmpArchive.endsWith(".zip")) {
            FileUtil.unZip((File)srcFile, (File)destDir);
        } else if (DistCacheUtils.isTarFile(tmpArchive)) {
            FileUtil.unTar((File)srcFile, (File)destDir);
        } else {
            LOG.warn((Object)String.format("Cache file %s specified as archive, but not valid extension.", srcFile.toString()));
            return cacheArchive;
        }
        return new Path(destDir.toString());
    }

    private static boolean isTarFile(String filename) {
        return filename.endsWith(".tgz") || filename.endsWith(".tar.gz") || filename.endsWith(".tar");
    }

    public static void addLocalFiles(Configuration conf, String str) {
        String files = conf.get(CACHE_LOCALFILES);
        conf.set(CACHE_LOCALFILES, files == null ? str : files + "," + str);
    }

    public static void addLocalArchives(Configuration conf, String str) {
        String files = conf.get(CACHE_LOCALARCHIVES);
        conf.set(CACHE_LOCALARCHIVES, files == null ? str : files + "," + str);
    }
}

