/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mrunit.internal.mapred.MockMapredOutputFormat;
import org.apache.hadoop.mrunit.internal.mapreduce.MockMapreduceOutputFormat;
import org.apache.hadoop.mrunit.internal.output.MockOutputCollector;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;

public class MockOutputCreator<K, V> {
    private Class<? extends org.apache.hadoop.mapred.OutputFormat> mapredOutputFormatClass;
    private Class<? extends org.apache.hadoop.mapred.InputFormat> mapredInputFormatClass;
    private Class<? extends OutputFormat> mapreduceOutputFormatClass;
    private Class<? extends InputFormat> mapreduceInputFormatClass;

    public void setMapredFormats(Class<? extends org.apache.hadoop.mapred.OutputFormat> outputFormatClass, Class<? extends org.apache.hadoop.mapred.InputFormat> inputFormatClass) {
        this.mapredOutputFormatClass = ArgumentChecker.returnNonNull(outputFormatClass);
        this.mapredInputFormatClass = ArgumentChecker.returnNonNull(inputFormatClass);
    }

    public void setMapreduceFormats(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.mapreduceOutputFormatClass = ArgumentChecker.returnNonNull(outputFormatClass);
        this.mapreduceInputFormatClass = ArgumentChecker.returnNonNull(inputFormatClass);
    }

    public OutputCollectable<K, V> createMapReduceOutputCollectable(Configuration configuration, Configuration outputCopyingOrInputFormatConfiguration, TaskInputOutputContext context) throws IOException {
        Configuration configuration2 = outputCopyingOrInputFormatConfiguration = outputCopyingOrInputFormatConfiguration == null ? configuration : outputCopyingOrInputFormatConfiguration;
        if (this.mapreduceOutputFormatClass != null) {
            return new MockMapreduceOutputFormat(new Job(configuration), this.mapreduceOutputFormatClass, this.mapreduceInputFormatClass, new Job(outputCopyingOrInputFormatConfiguration), (TaskAttemptContext)context);
        }
        return new MockOutputCollector(outputCopyingOrInputFormatConfiguration);
    }

    public OutputCollectable<K, V> createMapredOutputCollectable(Configuration configuration, Configuration outputCopyingOrInputFormatConfiguration) throws IOException {
        Configuration configuration2 = outputCopyingOrInputFormatConfiguration = outputCopyingOrInputFormatConfiguration == null ? configuration : outputCopyingOrInputFormatConfiguration;
        if (this.mapredOutputFormatClass != null) {
            return new MockMapredOutputFormat(new JobConf(configuration), this.mapredOutputFormatClass, this.mapredInputFormatClass, new JobConf(outputCopyingOrInputFormatConfiguration));
        }
        return new MockOutputCollector(outputCopyingOrInputFormatConfiguration);
    }
}

