/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mrunit.internal.output.MockOutputCollector;
import org.apache.hadoop.mrunit.types.Pair;

public class MockMultipleOutputs<K, V>
extends MultipleOutputs<K, V> {
    private Configuration configuration;
    private Map<String, MockOutputCollector> namedOutputCollectorMap;
    private Map<String, MockOutputCollector> pathCollectorMap;

    public MockMultipleOutputs(TaskInputOutputContext context) {
        super(context);
        this.configuration = new Configuration(context.getConfiguration());
        this.namedOutputCollectorMap = new HashMap<String, MockOutputCollector>();
        this.pathCollectorMap = new HashMap<String, MockOutputCollector>();
    }

    public boolean isNamedOutputsEmpty() {
        return this.namedOutputCollectorMap.isEmpty();
    }

    public int getMultipleOutputsCount() {
        return this.namedOutputCollectorMap.size();
    }

    public boolean isPathOutputsEmpty() {
        return this.pathCollectorMap.isEmpty();
    }

    public int getPathOutputsCount() {
        return this.pathCollectorMap.size();
    }

    public <K, V> void write(String namedOutput, K key, V value) throws IOException, InterruptedException {
        this.write(namedOutput, key, value, namedOutput);
    }

    public <K, V> void write(String namedOutput, K key, V value, String baseOutputPath) throws IOException, InterruptedException {
        MockOutputCollector<K, V> collector = this.namedOutputCollectorMap.get(namedOutput);
        if (collector == null) {
            collector = new MockOutputCollector<K, V>(this.configuration);
            this.namedOutputCollectorMap.put(namedOutput, collector);
        }
        collector.collect(key, value);
    }

    public void write(K key, V value, String baseOutputPath) throws IOException, InterruptedException {
        MockOutputCollector<K, V> collector = this.pathCollectorMap.get(baseOutputPath);
        if (collector == null) {
            collector = new MockOutputCollector<K, V>(this.configuration);
            this.pathCollectorMap.put(baseOutputPath, collector);
        }
        collector.collect(key, value);
    }

    public <K, V> List<Pair<K, V>> getMultipleOutputs(String outputName) {
        return this.namedOutputCollectorMap.get(outputName).getOutputs();
    }

    public List<String> getMultipleOutputsNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.namedOutputCollectorMap.keySet());
        return names;
    }

    public <K, V> List<Pair<K, V>> getPathOutputs(String outputName) {
        return this.pathCollectorMap.get(outputName).getOutputs();
    }

    public List<String> getOutputPaths() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.pathCollectorMap.keySet());
        return names;
    }
}

