/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mrunit.internal.mapreduce.AbstractMockContextWrapper;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.mapreduce.ReduceDriver;
import org.apache.hadoop.mrunit.types.KeyValueReuseList;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockReduceContextWrapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends AbstractMockContextWrapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT, Reducer.Context> {
    protected static final Log LOG = LogFactory.getLog(MockReduceContextWrapper.class);
    protected final List<KeyValueReuseList<KEYIN, VALUEIN>> inputs;
    protected final ReduceDriver<KEYIN, VALUEIN, KEYOUT, VALUEOUT> driver;
    protected KeyValueReuseList<KEYIN, VALUEIN> currentKeyValue;

    public MockReduceContextWrapper(Configuration configuration, List<KeyValueReuseList<KEYIN, VALUEIN>> inputs, MockOutputCreator<KEYOUT, VALUEOUT> mockOutputCreator, ReduceDriver<KEYIN, VALUEIN, KEYOUT, VALUEOUT> driver) {
        super(configuration, mockOutputCreator);
        this.inputs = inputs;
        this.driver = driver;
        this.context = this.create();
    }

    @Override
    protected Reducer.Context create() {
        Reducer.Context context = (Reducer.Context)Mockito.mock(Reducer.Context.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.createCommon((TaskInputOutputContext)context, this.driver, this.mockOutputCreator);
        try {
            Mockito.when((Object)context.nextKey()).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) {
                    if (MockReduceContextWrapper.this.inputs.size() > 0) {
                        MockReduceContextWrapper.this.currentKeyValue = MockReduceContextWrapper.this.inputs.remove(0);
                        return true;
                    }
                    MockReduceContextWrapper.this.currentKeyValue = null;
                    return false;
                }
            });
            Mockito.when((Object)context.getCurrentKey()).thenAnswer(new Answer<KEYIN>(){

                public KEYIN answer(InvocationOnMock invocation) {
                    return MockReduceContextWrapper.this.currentKeyValue.getCurrentKey();
                }
            });
            Mockito.when((Object)context.getValues()).thenAnswer(new Answer<Iterable<VALUEIN>>(){

                public Iterable<VALUEIN> answer(InvocationOnMock invocation) {
                    return MockReduceContextWrapper.makeOneUseIterator(MockReduceContextWrapper.this.currentKeyValue.valueIterator());
                }
            });
            Mockito.when((Object)context.getTaskAttemptID()).thenAnswer((Answer)new Answer<TaskAttemptID>(){

                public TaskAttemptID answer(InvocationOnMock invocation) throws Throwable {
                    return TaskAttemptID.forName((String)"attempt__0000_r_000000_0");
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    protected static <V> Iterable<V> makeOneUseIterator(final Iterator<V> parent) {
        return new Iterable<V>(){
            private final Iterator<V> iter = new Iterator<V>(){
                private boolean used;

                @Override
                public boolean hasNext() {
                    if (this.used) {
                        return false;
                    }
                    return parent.hasNext();
                }

                @Override
                public V next() {
                    if (this.used) {
                        throw new IllegalStateException();
                    }
                    return parent.next();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException();
                }
            };

            @Override
            public Iterator<V> iterator() {
                return this.iter;
            }
        };
    }
}

