/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mrunit.internal.mapreduce.AbstractMockContextWrapper;
import org.apache.hadoop.mrunit.internal.mapreduce.MockInputSplit;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockMapContextWrapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends AbstractMockContextWrapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT, Mapper.Context> {
    protected static final Log LOG = LogFactory.getLog(MockMapContextWrapper.class);
    protected final List<Pair<KEYIN, VALUEIN>> inputs;
    protected final MapDriver<KEYIN, VALUEIN, KEYOUT, VALUEOUT> driver;
    protected Pair<KEYIN, VALUEIN> currentKeyValue;

    public MockMapContextWrapper(Configuration configuration, List<Pair<KEYIN, VALUEIN>> inputs, MockOutputCreator<KEYOUT, VALUEOUT> mockOutputCreator, MapDriver<KEYIN, VALUEIN, KEYOUT, VALUEOUT> driver) {
        super(configuration, mockOutputCreator);
        this.inputs = inputs;
        this.driver = driver;
        this.context = this.create();
    }

    @Override
    protected Mapper.Context create() {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.createCommon((TaskInputOutputContext)context, this.driver, this.mockOutputCreator);
        try {
            Mockito.when((Object)context.nextKeyValue()).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) {
                    if (MockMapContextWrapper.this.inputs.size() > 0) {
                        MockMapContextWrapper.this.currentKeyValue = MockMapContextWrapper.this.inputs.remove(0);
                        return true;
                    }
                    MockMapContextWrapper.this.currentKeyValue = null;
                    return false;
                }
            });
            Mockito.when((Object)context.getCurrentKey()).thenAnswer(new Answer<KEYIN>(){

                public KEYIN answer(InvocationOnMock invocation) {
                    return MockMapContextWrapper.this.currentKeyValue.getFirst();
                }
            });
            Mockito.when((Object)context.getCurrentValue()).thenAnswer(new Answer<VALUEIN>(){

                public VALUEIN answer(InvocationOnMock invocation) {
                    return MockMapContextWrapper.this.currentKeyValue.getSecond();
                }
            });
            Mockito.when((Object)context.getTaskAttemptID()).thenAnswer((Answer)new Answer<TaskAttemptID>(){

                public TaskAttemptID answer(InvocationOnMock invocation) throws Throwable {
                    return TaskAttemptID.forName((String)"attempt__0000_m_000000_0");
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Mockito.when((Object)context.getInputSplit()).thenAnswer((Answer)new Answer<InputSplit>(){

            public InputSplit answer(InvocationOnMock invocation) throws Throwable {
                return new MockInputSplit(MockMapContextWrapper.this.driver.getMapInputPath());
            }
        });
        return context;
    }
}

