/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapred;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mrunit.internal.mapred.MockInputSplit;

public class MockReporter
implements Reporter {
    private final MockInputSplit inputSplit;
    private final Counters counters;
    private final ReporterType typ;

    public MockReporter(ReporterType kind, Counters ctrs) {
        this(kind, ctrs, null);
    }

    public MockReporter(ReporterType kind, Counters ctrs, Path mapInputPath) {
        this.typ = kind;
        this.counters = ctrs;
        this.inputSplit = mapInputPath == null ? null : new MockInputSplit(mapInputPath);
    }

    public InputSplit getInputSplit() {
        if (this.typ == ReporterType.Reducer) {
            throw new UnsupportedOperationException("Reducer cannot call getInputSplit()");
        }
        return this.inputSplit;
    }

    public void incrCounter(Enum<?> key, long amount) {
        this.counters.incrCounter(key, amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.counters.incrCounter(group, counter, amount);
    }

    public void setStatus(String status) {
    }

    public void progress() {
    }

    public Counters.Counter getCounter(String group, String name) {
        return this.counters.findCounter(group, name);
    }

    public Counters.Counter getCounter(Enum<?> key) {
        return (Counters.Counter)this.counters.findCounter(key);
    }

    public float getProgress() {
        return 0.0f;
    }

    public static enum ReporterType {
        Mapper,
        Reducer;

    }
}

