/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.counters;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;

public class CounterWrapper {
    private org.apache.hadoop.mapred.Counters mapred;
    private Counters mapreduce;

    public CounterWrapper(org.apache.hadoop.mapred.Counters counters) {
        this.mapred = ArgumentChecker.returnNonNull(counters);
    }

    public CounterWrapper(Counters counters) {
        this.mapreduce = ArgumentChecker.returnNonNull(counters);
    }

    public long findCounterValue(Enum<?> e) {
        if (this.mapred != null) {
            return ((Counters.Counter)this.mapred.findCounter(e)).getValue();
        }
        return this.mapreduce.findCounter(e).getValue();
    }

    public long findCounterValue(String group, String name) {
        if (this.mapred != null) {
            return this.mapred.findCounter(group, name).getValue();
        }
        return this.mapreduce.findCounter(group, name).getValue();
    }

    public Iterable<String> getGroupNames() {
        if (this.mapred != null) {
            return this.mapred.getGroupNames();
        }
        return this.mapreduce.getGroupNames();
    }

    public Collection<Pair<String, String>> findCounterValues() {
        LinkedList<Pair<String, String>> counters = new LinkedList<Pair<String, String>>();
        Iterable<String> groupNames = this.getGroupNames();
        if (this.mapred != null) {
            for (String groupName : groupNames) {
                Counters.Group group = this.mapred.getGroup(groupName);
                this.collectCounters(counters, groupName, group.iterator());
            }
        } else {
            for (String groupName : groupNames) {
                CounterGroup group = (CounterGroup)this.mapreduce.getGroup(groupName);
                this.collectCounters(counters, groupName, group.iterator());
            }
        }
        return counters;
    }

    private void collectCounters(Collection<Pair<String, String>> counters, String groupName, Iterator<? extends Counter> iterator) {
        while (iterator.hasNext()) {
            String counter = iterator.next().getName();
            counters.add(new Pair<String, String>(groupName, counter));
        }
    }
}

