/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import com.google.common.io.LineReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private Map<String, ServiceStream> serviceEntries = new HashMap<String, ServiceStream>();

    @Override
    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        String line;
        ServiceStream out = this.serviceEntries.get(resource);
        if (out == null) {
            out = new ServiceStream();
            this.serviceEntries.put(resource, out);
        }
        ServiceStream fout = out;
        String content = IOUtils.toString((InputStream)is);
        StringReader reader = new StringReader(content);
        LineReader lineReader = new LineReader((Readable)reader);
        while ((line = lineReader.readLine()) != null) {
            String relContent = line;
            for (Relocator relocator : relocators) {
                relContent = relocator.applyToSourceContent(relContent);
            }
            fout.append(relContent + "\n");
        }
        is.close();
    }

    @Override
    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ServiceStream> entry : this.serviceEntries.entrySet()) {
            String key = entry.getKey();
            ServiceStream data = entry.getValue();
            jos.putNextEntry(new JarEntry(key));
            IOUtil.copy((InputStream)data.toInputStream(), (OutputStream)jos);
            data.reset();
        }
    }

    static class ServiceStream
    extends ByteArrayOutputStream {
        public ServiceStream() {
            super(1024);
        }

        public void append(String content) throws IOException {
            if (this.count > 0 && this.buf[this.count - 1] != 10 && this.buf[this.count - 1] != 13) {
                this.write(10);
            }
            byte[] contentBytes = content.getBytes("UTF-8");
            this.write(contentBytes);
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

