/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.MinijarFilter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.apache.maven.plugins.shade.mojo.ArtifactSelector;
import org.apache.maven.plugins.shade.mojo.ArtifactSet;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.pom.PomWriter;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class ShadeMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private Shader shader;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private ArtifactSet artifactSet;
    private PackageRelocation[] relocations;
    private ResourceTransformer[] transformers;
    private ArchiveFilter[] filters;
    private File outputDirectory;
    private String finalName;
    private String shadedArtifactId;
    private String shadedGroupFilter;
    private boolean shadedArtifactAttached;
    private boolean createDependencyReducedPom;
    private boolean keepDependenciesWithProvidedScope;
    private boolean promoteTransitiveDependencies;
    private String shadedClassifierName;
    private boolean createSourcesJar;
    private boolean minimizeJar;
    private File outputFile;

    public void execute() throws MojoExecutionException {
        LinkedHashSet<File> artifacts = new LinkedHashSet<File>();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        LinkedHashSet<File> sourceArtifacts = new LinkedHashSet<File>();
        ArtifactSelector artifactSelector = new ArtifactSelector(this.project.getArtifact(), this.artifactSet, this.shadedGroupFilter);
        if (artifactSelector.isSelected(this.project.getArtifact()) && !"pom".equals(this.project.getArtifact().getType())) {
            File file;
            if (this.project.getArtifact().getFile() == null) {
                this.getLog().error((CharSequence)"The project main artifact does not exist. This could have the following");
                this.getLog().error((CharSequence)"reasons:");
                this.getLog().error((CharSequence)"- You have invoked the goal directly from the command line. This is not");
                this.getLog().error((CharSequence)"  supported. Please add the goal to the default lifecycle via an");
                this.getLog().error((CharSequence)"  <execution> element in your POM and use \"mvn package\" to have it run.");
                this.getLog().error((CharSequence)"- You have bound the goal to a lifecycle phase before \"package\". Please");
                this.getLog().error((CharSequence)"  remove this binding from your POM such that the goal will be run in");
                this.getLog().error((CharSequence)"  the proper phase.");
                throw new MojoExecutionException("Failed to create shaded artifact, project main artifact does not exist.");
            }
            artifacts.add(this.project.getArtifact().getFile());
            if (this.createSourcesJar && (file = this.shadedSourcesArtifactFile()).isFile()) {
                sourceArtifacts.add(file);
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            File file;
            if (!artifactSelector.isSelected(artifact)) {
                this.getLog().info((CharSequence)("Excluding " + artifact.getId() + " from the shaded jar."));
                continue;
            }
            if ("pom".equals(artifact.getType())) {
                this.getLog().info((CharSequence)("Skipping pom dependency " + artifact.getId() + " in the shaded jar."));
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the shaded jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
            if (!this.createSourcesJar || (file = this.resolveArtifactSources(artifact)) == null) continue;
            sourceArtifacts.add(file);
        }
        File outputJar = this.outputFile != null ? this.outputFile : this.shadedArtifactFileWithClassifier();
        File sourcesJar = this.shadedSourceArtifactFileWithClassifier();
        try {
            List filters = this.getFilters();
            List relocators = this.getRelocators();
            List resourceTransformers = this.getResourceTransformers();
            this.shader.shade(artifacts, outputJar, filters, relocators, resourceTransformers);
            if (this.createSourcesJar) {
                this.shader.shade(sourceArtifacts, sourcesJar, filters, relocators, resourceTransformers);
            }
            if (this.outputFile == null) {
                boolean renamed = false;
                if (this.finalName != null && this.finalName.length() > 0 && !this.finalName.equals(this.project.getBuild().getFinalName())) {
                    String finalFileName = this.finalName + "." + this.project.getArtifact().getArtifactHandler().getExtension();
                    File finalFile = new File(this.outputDirectory, finalFileName);
                    this.replaceFile(finalFile, outputJar);
                    outputJar = finalFile;
                    renamed = true;
                }
                if (this.shadedArtifactAttached) {
                    this.getLog().info((CharSequence)"Attaching shaded artifact.");
                    this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.shadedClassifierName, outputJar);
                    if (this.createSourcesJar) {
                        this.projectHelper.attachArtifact(this.project, "jar", this.shadedClassifierName + "-sources", sourcesJar);
                    }
                } else if (!renamed) {
                    this.getLog().info((CharSequence)"Replacing original artifact with shaded artifact.");
                    File originalArtifact = this.project.getArtifact().getFile();
                    this.replaceFile(originalArtifact, outputJar);
                    if (this.createSourcesJar) {
                        File shadedSources = this.shadedSourcesArtifactFile();
                        this.replaceFile(shadedSources, sourcesJar);
                        this.projectHelper.attachArtifact(this.project, "jar", "sources", shadedSources);
                    }
                    if (this.createDependencyReducedPom) {
                        this.createDependencyReducedPom(artifactIds);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating shaded jar: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        FileInputStream fin;
        FileOutputStream fout;
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    fout = new FileOutputStream(origFile);
                    fin = new FileInputStream(oldFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    fout = new FileOutputStream(oldFile);
                    fin = new FileInputStream(newFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with shaded artifact!", (Exception)ex);
                }
            }
        }
    }

    private File resolveArtifactSources(Artifact artifact) {
        Artifact resolvedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Could not get sources for " + artifact));
        }
        if (resolvedArtifact.isResolved()) {
            return resolvedArtifact.getFile();
        }
        return null;
    }

    private List getRelocators() {
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (int i = 0; i < this.relocations.length; ++i) {
            PackageRelocation r = this.relocations[i];
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getIncludes(), r.getExcludes()));
        }
        return relocators;
    }

    private List getResourceTransformers() {
        if (this.transformers == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.transformers);
    }

    private List getFilters() throws MojoExecutionException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.filters != null && this.filters.length > 0) {
            HashMap<Artifact, ArtifactId> artifacts = new HashMap<Artifact, ArtifactId>();
            artifacts.put(this.project.getArtifact(), new ArtifactId(this.project.getArtifact()));
            for (Artifact artifact : this.project.getArtifacts()) {
                artifacts.put(artifact, new ArtifactId(artifact));
            }
            for (int i = 0; i < this.filters.length; ++i) {
                ArchiveFilter filter = this.filters[i];
                ArtifactId pattern = new ArtifactId(filter.getArtifact());
                HashSet<File> jars = new HashSet<File>();
                for (Map.Entry entry : artifacts.entrySet()) {
                    File file;
                    if (!((ArtifactId)entry.getValue()).matches(pattern)) continue;
                    Artifact artifact = (Artifact)entry.getKey();
                    jars.add(artifact.getFile());
                    if (!this.createSourcesJar || (file = this.resolveArtifactSources(artifact)) == null) continue;
                    jars.add(file);
                }
                if (jars.isEmpty()) {
                    this.getLog().info((CharSequence)("No artifact matching filter " + filter.getArtifact()));
                    continue;
                }
                filters.add(new SimpleFilter(jars, filter.getIncludes(), filter.getExcludes()));
            }
        }
        if (this.minimizeJar) {
            this.getLog().info((CharSequence)("Minimizing jar " + this.project.getArtifact()));
            try {
                filters.add(new MinijarFilter(this.project, this.getLog()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to analyze class dependencies", (Exception)e);
            }
        }
        return filters;
    }

    private File shadedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourceArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourcesArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.project.getBuild().getFinalName() != null ? this.project.getBuild().getFinalName() + "-sources." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDependencyReducedPom(Set artifactsToRemove) throws IOException, DependencyTreeBuilderException, ProjectBuildingException {
        Model model = this.project.getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        ArrayList<Dependency> transitiveDeps = new ArrayList<Dependency>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("pom".equals(artifact.getType())) continue;
            Dependency dep = new Dependency();
            dep.setArtifactId(artifact.getArtifactId());
            if (artifact.hasClassifier()) {
                dep.setClassifier(artifact.getClassifier());
            }
            dep.setGroupId(artifact.getGroupId());
            dep.setOptional(artifact.isOptional());
            dep.setScope(artifact.getScope());
            dep.setType(artifact.getType());
            dep.setVersion(artifact.getVersion());
            transitiveDeps.add(dep);
        }
        ArrayList<Dependency> origDeps = this.project.getDependencies();
        if (this.promoteTransitiveDependencies) {
            origDeps = transitiveDeps;
        }
        for (Dependency d : origDeps) {
            dependencies.add(d);
            String id = this.getId(d);
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            if (this.keepDependenciesWithProvidedScope) {
                d.setScope("provided");
                continue;
            }
            dependencies.remove(d);
        }
        if (modified) {
            File f;
            while (modified) {
                model.setDependencies(dependencies);
                f = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
                if (f.exists()) {
                    f.delete();
                }
                XmlStreamWriter w = WriterFactory.newXmlWriter((File)f);
                try {
                    PomWriter.write((Writer)w, model, true);
                }
                finally {
                    w.close();
                }
                MavenProject p2 = this.mavenProjectBuilder.build(f, this.localRepository, null);
                modified = this.updateExcludesInDeps(p2, dependencies, transitiveDeps);
            }
            f = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
            File f2 = new File(this.outputDirectory, "dependency-reduced-pom.xml");
            FileUtils.copyFile((File)f, (File)f2);
            FileUtils.forceDeleteOnExit((File)f);
            this.project.setFile(f);
        }
    }

    private String getId(Artifact artifact) {
        return this.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    private String getId(Dependency dependency) {
        return this.getId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier());
    }

    private String getId(String groupId, String artifactId, String type, String classifier) {
        return groupId + ":" + artifactId + ":" + type + ":" + (classifier != null ? classifier : "");
    }

    public boolean updateExcludesInDeps(MavenProject project, List dependencies, List transitiveDeps) throws DependencyTreeBuilderException {
        DependencyNode node = this.dependencyTreeBuilder.buildDependencyTree(project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
        boolean modified = false;
        ListIterator it = node.getChildren().listIterator();
        while (it.hasNext()) {
            DependencyNode n2 = (DependencyNode)it.next();
            ListIterator it2 = n2.getChildren().listIterator();
            block1: while (it2.hasNext()) {
                Dependency dep;
                int x;
                DependencyNode n3 = (DependencyNode)it2.next();
                if (n3.getState() != 0) continue;
                boolean found = false;
                for (x = 0; x < transitiveDeps.size(); ++x) {
                    dep = (Dependency)transitiveDeps.get(x);
                    if (!dep.getArtifactId().equals(n3.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n3.getArtifact().getGroupId())) continue;
                    found = true;
                }
                if (found) continue;
                for (x = 0; x < dependencies.size(); ++x) {
                    dep = (Dependency)dependencies.get(x);
                    if (!dep.getArtifactId().equals(n2.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n2.getArtifact().getGroupId())) continue;
                    Exclusion exclusion = new Exclusion();
                    exclusion.setArtifactId(n3.getArtifact().getArtifactId());
                    exclusion.setGroupId(n3.getArtifact().getGroupId());
                    dep.addExclusion(exclusion);
                    modified = true;
                    continue block1;
                }
            }
        }
        return modified;
    }
}

