/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;

public class EffectiveSettingsMojo
extends AbstractMojo {
    private Settings settings;
    private String output;

    public void execute() throws MojoExecutionException {
        StringWriter sWriter = new StringWriter();
        SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
        try {
            settingsWriter.write((Writer)sWriter, this.settings);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize Settings to XML.", (Exception)e);
        }
        if (this.output != null && this.output.trim().length() > 0) {
            OutputStreamWriter fWriter = null;
            try {
                File outFile = new File(this.output).getAbsoluteFile();
                File dir = outFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                this.getLog().info((CharSequence)("Writing effective-settings to: " + outFile));
                fWriter = new FileWriter(outFile);
                fWriter.write(sWriter.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-settings to output: " + this.output, (Exception)e);
            }
            finally {
                if (fWriter != null) {
                    try {
                        fWriter.close();
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Cannot close FileWriter to output location: " + this.output), (Throwable)e);
                    }
                }
            }
        }
        StringBuffer message = new StringBuffer();
        message.append("\nEffective settings:\n\n");
        message.append(sWriter.toString());
        message.append("\n\n");
        this.getLog().info((CharSequence)message);
    }

    public final void setOutput(String output) {
        this.output = output;
    }

    public final void setSettings(Settings settings) {
        this.settings = settings;
    }
}

