/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AbstractUnpackingMojo;
import org.apache.maven.plugin.assembly.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugin.assembly.filter.AssemblyExcludesArtifactFilter;
import org.apache.maven.plugin.assembly.filter.AssemblyIncludesArtifactFilter;
import org.apache.maven.plugin.assembly.filter.AssemblyScopeArtifactFilter;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.interpolation.ReflectionProperties;
import org.apache.maven.plugin.assembly.repository.RepositoryAssembler;
import org.apache.maven.plugin.assembly.repository.RepositoryAssemblyException;
import org.apache.maven.plugin.assembly.utils.PropertyUtils;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.Component;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugins.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractAssemblyMojo
extends AbstractUnpackingMojo {
    private File[] descriptors;
    private String[] descriptorRefs;
    private File descriptorSourceDirectory;
    private File archiveBaseDirectory;
    protected String descriptorId;
    protected File descriptor;
    private String tarLongFileMode;
    private File basedir;
    private MavenProjectHelper projectHelper;
    private File tempRoot;
    private File siteDirectory;
    private boolean includeSite;
    protected boolean appendAssemblyId;
    private ComponentsXmlArchiverFileFilter componentsXmlFilter = new ComponentsXmlArchiverFileFilter();
    private MavenArchiveConfiguration archive;
    protected List filters;
    private Properties filterProperties;
    private RepositoryAssembler repositoryAssembler;
    private static final String LS = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException, MojoFailureException {
        List assemblies = this.readAssemblies();
        Iterator i = assemblies.iterator();
        while (i.hasNext()) {
            Assembly assembly = (Assembly)i.next();
            this.createAssembly(assembly);
        }
    }

    private void createAssembly(Assembly assembly) throws MojoExecutionException, MojoFailureException {
        String fullName = this.getDistributionName(assembly);
        Iterator i = assembly.getFormats().iterator();
        while (i.hasNext()) {
            File destFile;
            String format = (String)i.next();
            String filename = fullName + "." + format;
            try {
                Archiver archiver = this.createArchiver(format);
                destFile = this.createArchive(archiver, assembly, filename);
            }
            catch (NoSuchArchiverException e) {
                throw new MojoFailureException("Unable to obtain archiver for extension '" + format + "'");
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)e);
            }
            catch (RepositoryAssemblyException e) {
                throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)e);
            }
            if (this.appendAssemblyId) {
                this.projectHelper.attachArtifact(this.project, format, assembly.getId(), destFile);
                continue;
            }
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, format, this.classifier, destFile);
                continue;
            }
            this.projectHelper.attachArtifact(this.project, format, null, destFile);
        }
    }

    protected String getDistributionName(Assembly assembly) {
        String distributionName = this.finalName;
        if (this.appendAssemblyId) {
            if (!StringUtils.isEmpty((String)assembly.getId())) {
                distributionName = this.finalName + "-" + assembly.getId();
            }
        } else if (this.classifier != null) {
            distributionName = this.finalName + "-" + this.classifier;
        }
        return distributionName;
    }

    protected File createArchive(Archiver archiver, Assembly assembly, String filename) throws MojoExecutionException, MojoFailureException, IOException, ArchiverException, RepositoryAssemblyException {
        this.processRepositories(archiver, assembly.getRepositories(), assembly.isIncludeBaseDirectory());
        this.processDependencySets(archiver, assembly.getDependencySets(), assembly.isIncludeBaseDirectory());
        this.processModules(archiver, assembly.getModuleSets(), assembly.isIncludeBaseDirectory());
        this.processFileSets(archiver, assembly.getFileSets(), assembly.isIncludeBaseDirectory());
        this.processFileList(archiver, assembly.getFiles(), assembly.isIncludeBaseDirectory());
        this.componentsXmlFilter.addToArchive(archiver);
        File destFile = new File(this.outputDirectory, filename);
        if (archiver instanceof JarArchiver) {
            MavenArchiver mavenArchiver = new MavenArchiver();
            if (this.archive != null) {
                try {
                    Manifest manifest;
                    File manifestFile = this.archive.getManifestFile();
                    if (manifestFile != null) {
                        try {
                            manifest = new Manifest((Reader)new FileReader(manifestFile));
                        }
                        catch (FileNotFoundException e) {
                            throw new MojoFailureException("Manifest not found: " + e.getMessage());
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Error processing manifest: " + e.getMessage(), (Exception)e);
                        }
                    } else {
                        manifest = mavenArchiver.getManifest(this.project, this.archive.getManifest());
                    }
                    if (manifest != null) {
                        JarArchiver jarArchiver = (JarArchiver)archiver;
                        jarArchiver.addConfiguredManifest(manifest);
                    }
                }
                catch (ManifestException e) {
                    throw new MojoExecutionException("Error creating manifest: " + e.getMessage(), (Exception)((Object)e));
                }
                catch (DependencyResolutionRequiredException e) {
                    throw new MojoExecutionException("Dependencies were not resolved: " + e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        archiver.setDestFile(destFile);
        archiver.createArchive();
        return destFile;
    }

    private void processRepositories(Archiver archiver, List modulesList, boolean includeBaseDirectory) throws RepositoryAssemblyException, MojoExecutionException {
        Iterator i = modulesList.iterator();
        while (i.hasNext()) {
            File repositoryDirectory;
            Repository repository = (Repository)i.next();
            AndArtifactFilter filter = new AndArtifactFilter();
            if (repository.getIncludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyIncludesArtifactFilter(this.getDependenciesIncludeList()));
            } else {
                filter.add((ArtifactFilter)new AssemblyIncludesArtifactFilter(repository.getIncludes()));
            }
            if (!repository.getExcludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyExcludesArtifactFilter(repository.getExcludes()));
            }
            if (!(repositoryDirectory = new File(this.tempRoot, repository.getOutputDirectory())).exists()) {
                repositoryDirectory.mkdirs();
            }
            this.repositoryAssembler.assemble(repositoryDirectory, repository, this.project, this.localRepository);
            try {
                if (includeBaseDirectory) {
                    archiver.addDirectory(repositoryDirectory, repository.getOutputDirectory() + "/");
                    continue;
                }
                archiver.addDirectory(repositoryDirectory);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding directory to archive: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processModules(Archiver archiver, List moduleSets, boolean includeBaseDirectory) throws MojoFailureException, MojoExecutionException {
        i = moduleSets.iterator();
        while (i.hasNext()) {
            moduleSet = (ModuleSet)i.next();
            filter = new AndArtifactFilter();
            if (!moduleSet.getIncludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyIncludesArtifactFilter(moduleSet.getIncludes()));
            }
            if (!moduleSet.getExcludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyExcludesArtifactFilter(moduleSet.getExcludes()));
            }
            set = this.getModulesFromReactor(this.getExecutedProject());
            moduleFileSets = new ArrayList<FileSet>();
            j = set.iterator();
            while (j.hasNext()) {
                moduleProject = (MavenProject)j.next();
                if (filter.include(moduleProject.getArtifact())) {
                    name = moduleProject.getBuild().getFinalName();
                    sources = moduleSet.getSources();
                    if (sources != null) {
                        output = sources.getOutputDirectory();
                        output = this.getOutputDirectory(output, moduleProject, includeBaseDirectory);
                        moduleFileSet = new FileSet();
                        moduleFileSet.setDirectory(moduleProject.getBasedir().getAbsolutePath());
                        moduleFileSet.setOutputDirectory(output);
                        excludesList = new ArrayList<String>();
                        excludesList.add(PathUtils.toRelative((File)moduleProject.getBasedir(), (String)moduleProject.getBuild().getDirectory()) + "/**");
                        excludesList.add(PathUtils.toRelative((File)moduleProject.getBasedir(), (String)moduleProject.getBuild().getOutputDirectory()) + "/**");
                        excludesList.add(PathUtils.toRelative((File)moduleProject.getBasedir(), (String)moduleProject.getBuild().getTestOutputDirectory()) + "/**");
                        excludesList.add(PathUtils.toRelative((File)moduleProject.getBasedir(), (String)moduleProject.getReporting().getOutputDirectory()) + "/**");
                        moduleFileSet.setExcludes(excludesList);
                        moduleFileSets.add(moduleFileSet);
                    }
                    if ((binaries = moduleSet.getBinaries()) != null) {
                        artifact = moduleProject.getArtifact();
                        if (artifact.getFile() == null) {
                            throw new MojoExecutionException("Included module: " + moduleProject.getId() + " does not have an artifact with a file. Please ensure the package phase is run before the assembly is generated.");
                        }
                        output = binaries.getOutputDirectory();
                        output = this.getOutputDirectory(output, moduleProject, includeBaseDirectory);
                        archiver.setDefaultDirectoryMode(Integer.parseInt(binaries.getDirectoryMode(), 8));
                        archiver.setDefaultFileMode(Integer.parseInt(binaries.getFileMode(), 8));
                        this.getLog().debug((CharSequence)("ModuleSet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8)));
                        if (binaries.isUnpack()) {
                            tempLocation = new File(this.workDirectory, name);
                            process = false;
                            if (!tempLocation.exists()) {
                                tempLocation.mkdirs();
                                process = true;
                            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                                process = true;
                            }
                            if (process) {
                                try {
                                    this.unpack(artifact.getFile(), tempLocation);
                                    if (binaries.isIncludeDependencies()) {
                                        artifactSet = moduleProject.getArtifacts();
                                        artifacts = artifactSet.iterator();
                                        while (artifacts.hasNext()) {
                                            dependencyArtifact = (Artifact)artifacts.next();
                                            this.unpack(dependencyArtifact.getFile(), tempLocation);
                                        }
                                    }
                                }
                                catch (NoSuchArchiverException e) {
                                    throw new MojoExecutionException("Unable to obtain unarchiver: " + e.getMessage(), (Exception)e);
                                }
                                if (archiver instanceof JarArchiver) {
                                    securityFiles = new String[]{"*.RSA", "*.DSA", "*.SF", "*.rsa", "*.dsa", "*.sf"};
                                    securityFileSet = new org.apache.maven.shared.model.fileset.FileSet();
                                    securityFileSet.setDirectory(tempLocation.getAbsolutePath() + "/META-INF/");
                                    for (sfsi = 0; sfsi < securityFiles.length; ++sfsi) {
                                        securityFileSet.addInclude(securityFiles[sfsi]);
                                    }
                                    fsm = new FileSetManager(this.getLog());
                                    try {
                                        fsm.delete(securityFileSet);
                                    }
                                    catch (IOException e) {
                                        throw new MojoExecutionException("Failed to delete security files: " + e.getMessage(), (Exception)e);
                                    }
                                }
                            }
                            this.addDirectory(archiver, tempLocation, output, null, FileUtils.getDefaultExcludesAsList());
                        } else {
                            try {
                                outputFileNameMapping = binaries.getOutputFileNameMapping();
                                archiver.addFile(artifact.getFile(), output + AbstractAssemblyMojo.evaluateFileNameMapping(artifact, outputFileNameMapping));
                                if (!binaries.isIncludeDependencies()) ** GOTO lbl98
                                artifactSet = moduleProject.getArtifacts();
                                artifacts = artifactSet.iterator();
                                while (artifacts.hasNext()) {
                                    dependencyArtifact = (Artifact)artifacts.next();
                                    archiver.addFile(dependencyArtifact.getFile(), output + AbstractAssemblyMojo.evaluateFileNameMapping(dependencyArtifact, outputFileNameMapping));
                                }
                            }
                            catch (ArchiverException e) {
                                throw new MojoExecutionException("Error adding file to archive: " + e.getMessage(), (Exception)e);
                            }
                        }
                    }
                } else {
                    this.getLog().debug((CharSequence)("module: " + moduleProject.getId() + " not included"));
                }
lbl98:
                // 5 sources

                if (moduleFileSets.isEmpty()) continue;
                this.processFileSets(archiver, moduleFileSets, includeBaseDirectory);
            }
        }
    }

    private static String evaluateFileNameMapping(Artifact artifact, String mapping) throws MojoExecutionException {
        String fileNameMapping = mapping;
        if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
            int dotIdx = fileNameMapping.lastIndexOf(".");
            if (dotIdx >= 0) {
                String extension = fileNameMapping.substring(dotIdx + 1, fileNameMapping.length());
                String artifactWithoutExt = fileNameMapping.substring(0, dotIdx);
                fileNameMapping = artifactWithoutExt + "-" + artifact.getClassifier() + "." + extension;
            } else {
                fileNameMapping = fileNameMapping + "-" + artifact.getClassifier();
            }
        }
        return AbstractAssemblyMojo.evaluateFileNameMapping(fileNameMapping, artifact);
    }

    private Set getModulesFromReactor(MavenProject parent) {
        return this.getModulesFromReactor(parent, false);
    }

    private Set getModulesFromReactor(MavenProject parent, boolean recurse) {
        HashSet<MavenProject> modules = new HashSet<MavenProject>();
        String parentId = parent.getId();
        Iterator i = this.reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject reactorProject = (MavenProject)i.next();
            if (!this.isProjectModule(parentId, reactorProject, recurse)) continue;
            modules.add(reactorProject);
        }
        return modules;
    }

    private boolean isProjectModule(String parentId, MavenProject reactorProject, boolean recurse) {
        MavenProject parent = reactorProject.getParent();
        if (parent != null) {
            if (parent.getId().equals(parentId)) {
                return true;
            }
            if (recurse) {
                this.isProjectModule(parentId, parent, true);
            }
        }
        return false;
    }

    protected List readAssemblies() throws MojoFailureException, MojoExecutionException {
        int i;
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        if (this.descriptor != null) {
            assemblies.add(this.getAssembly(this.descriptor));
        }
        if (this.descriptorId != null) {
            assemblies.add(this.getAssembly(this.descriptorId));
        }
        if (this.descriptors != null && this.descriptors.length > 0) {
            for (i = 0; i < this.descriptors.length; ++i) {
                assemblies.add(this.getAssembly(this.descriptors[i]));
            }
        }
        if (this.descriptorRefs != null && this.descriptorRefs.length > 0) {
            for (i = 0; i < this.descriptorRefs.length; ++i) {
                assemblies.add(this.getAssembly(this.descriptorRefs[i]));
            }
        }
        if (this.descriptorSourceDirectory != null && this.descriptorSourceDirectory.isDirectory()) {
            try {
                List descriptorList = FileUtils.getFiles((File)this.descriptorSourceDirectory, (String)"**/*.xml", null);
                Iterator iter = descriptorList.iterator();
                while (iter.hasNext()) {
                    assemblies.add(this.getAssembly((File)iter.next()));
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("error discovering descriptor files: " + e.getMessage());
            }
        }
        if (assemblies.isEmpty()) {
            throw new MojoFailureException("No assembly descriptors found.");
        }
        HashSet<String> ids = new HashSet<String>();
        Iterator i2 = assemblies.iterator();
        while (i2.hasNext()) {
            Assembly assembly = (Assembly)i2.next();
            if (ids.add(assembly.getId())) continue;
            throw new MojoFailureException("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    private Assembly getAssembly(String ref) throws MojoFailureException, MojoExecutionException {
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            throw new MojoFailureException("Descriptor with ID '" + ref + "' not found");
        }
        return this.getAssembly(new InputStreamReader(resourceAsStream));
    }

    private Assembly getAssembly(File file) throws MojoFailureException, MojoExecutionException {
        FileReader r;
        try {
            r = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Unable to find descriptor: " + e.getMessage());
        }
        return this.getAssembly(r);
    }

    private Assembly getAssembly(Reader reader) throws MojoFailureException, MojoExecutionException {
        Assembly assembly;
        try {
            HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
            context.put("basedir", this.basedir.getAbsolutePath());
            AssemblyXpp3Reader r = new AssemblyXpp3Reader();
            assembly = r.read(reader);
            assembly = new AssemblyInterpolator().interpolate(assembly, this.project.getModel(), context);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading descriptor", (Exception)((Object)e));
        }
        catch (AssemblyInterpolationException e) {
            throw new MojoExecutionException("Error reading descriptor: " + e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (this.includeSite || assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly);
        }
        this.appendComponentsToMainAssembly(assembly);
        return assembly;
    }

    private void appendComponentsToMainAssembly(Assembly assembly) throws MojoFailureException, MojoExecutionException {
        List componentDescriptorFiles = assembly.getComponentDescriptors();
        for (int i = 0; i < componentDescriptorFiles.size(); ++i) {
            Component component = this.getComponent(componentDescriptorFiles.get(i).toString());
            this.appendComponent(assembly, component);
        }
    }

    private void appendComponent(Assembly assembly, Component component) {
        List dependencySetList = component.getDependencySets();
        for (int i = 0; i < dependencySetList.size(); ++i) {
            assembly.addDependencySet((DependencySet)dependencySetList.get(i));
        }
        List fileSetList = component.getFileSets();
        for (int i = 0; i < fileSetList.size(); ++i) {
            assembly.addFileSet((FileSet)fileSetList.get(i));
        }
        List fileList = component.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            assembly.addFile((FileItem)fileList.get(i));
        }
    }

    private Component getComponent(String filePath) throws MojoExecutionException, MojoFailureException {
        FileReader r;
        File componentDescriptor = new File(this.project.getBasedir() + "/" + filePath);
        try {
            r = new FileReader(componentDescriptor);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Unable to find descriptor: " + e.getMessage());
        }
        return this.getComponent(r);
    }

    private Component getComponent(Reader reader) throws MojoExecutionException {
        Component component;
        try {
            ComponentXpp3Reader r = new ComponentXpp3Reader();
            component = r.read(reader);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading component descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading component descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return component;
    }

    protected void processDependencySets(Archiver archiver, List dependencySets, boolean includeBaseDirectory) throws MojoExecutionException {
        Iterator i = dependencySets.iterator();
        while (i.hasNext()) {
            DependencySet dependencySet = (DependencySet)i.next();
            String output = dependencySet.getOutputDirectory();
            output = this.getOutputDirectory(output, this.project, includeBaseDirectory);
            archiver.setDefaultDirectoryMode(Integer.parseInt(dependencySet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(dependencySet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("DependencySet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8)));
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new AssemblyScopeArtifactFilter(dependencySet.getScope()));
            if (!dependencySet.getIncludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyIncludesArtifactFilter(dependencySet.getIncludes()));
            }
            if (!dependencySet.getExcludes().isEmpty()) {
                filter.add((ArtifactFilter)new AssemblyExcludesArtifactFilter(dependencySet.getExcludes()));
            }
            Iterator j = this.getDependencies().iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (filter.include(artifact)) {
                    String fileNameMapping = AbstractAssemblyMojo.evaluateFileNameMapping(artifact, dependencySet.getOutputFileNameMapping());
                    if (dependencySet.isUnpack()) {
                        File tempLocation = new File(this.workDirectory, fileNameMapping);
                        boolean process = false;
                        if (!tempLocation.exists()) {
                            tempLocation.mkdirs();
                            process = true;
                        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                            process = true;
                        }
                        if (process) {
                            try {
                                this.unpack(artifact.getFile(), tempLocation);
                            }
                            catch (NoSuchArchiverException e) {
                                throw new MojoExecutionException("Unable to obtain unarchiver for file '" + artifact.getFile() + "'");
                            }
                            if (archiver instanceof JarArchiver) {
                                String[] securityFiles = new String[]{"*.RSA", "*.DSA", "*.SF", "*.rsa", "*.dsa", "*.sf"};
                                org.apache.maven.shared.model.fileset.FileSet securityFileSet = new org.apache.maven.shared.model.fileset.FileSet();
                                securityFileSet.setDirectory(tempLocation.getAbsolutePath() + "/META-INF/");
                                for (int sfsi = 0; sfsi < securityFiles.length; ++sfsi) {
                                    securityFileSet.addInclude(securityFiles[sfsi]);
                                }
                                FileSetManager fsm = new FileSetManager(this.getLog());
                                try {
                                    fsm.delete(securityFileSet);
                                }
                                catch (IOException e) {
                                    throw new MojoExecutionException("Failed to delete security files: " + e.getMessage(), (Exception)e);
                                }
                            }
                        }
                        this.addDirectory(archiver, tempLocation, output, null, FileUtils.getDefaultExcludesAsList());
                        continue;
                    }
                    try {
                        archiver.addFile(artifact.getFile(), output + fileNameMapping);
                        continue;
                    }
                    catch (ArchiverException e) {
                        throw new MojoExecutionException("Error adding file '" + artifact.getFile() + "' to archive: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                this.getLog().debug((CharSequence)("artifact: " + artifact + " not included"));
            }
        }
    }

    private List getDependenciesIncludeList() {
        ArrayList<String> includes = new ArrayList<String>();
        Iterator i = this.getDependencies().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (this.project.getGroupId().equals(a.getGroupId()) && this.project.getArtifactId().equals(a.getArtifactId())) continue;
            includes.add(a.getGroupId() + ":" + a.getArtifactId());
        }
        return includes;
    }

    private void addDirectory(Archiver archiver, File directory, String output, String[] includes, List excludes) throws MojoExecutionException {
        if (directory.exists()) {
            ArrayList<String> adaptedExcludes = excludes;
            File componentsXml = new File(directory, "META-INF/plexus/components.xml");
            if (componentsXml.exists()) {
                try {
                    this.componentsXmlFilter.addComponentsXml(componentsXml);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading components.xml to merge: " + e.getMessage(), (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error reading components.xml to merge: " + e.getMessage(), (Exception)((Object)e));
                }
                adaptedExcludes = new ArrayList<String>(excludes);
                adaptedExcludes.add("META-INF/plexus/components.xml");
            }
            try {
                archiver.addDirectory(directory, output, includes, adaptedExcludes.toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY));
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding directory to archive: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected void processFileSets(Archiver archiver, List fileSets, boolean includeBaseDirecetory) throws MojoExecutionException, MojoFailureException {
        Iterator i = fileSets.iterator();
        while (i.hasNext()) {
            File archiveBaseDir;
            FileSet fileSet = (FileSet)i.next();
            String directory = fileSet.getDirectory();
            String output = fileSet.getOutputDirectory();
            String lineEnding = AbstractAssemblyMojo.getLineEndingCharacters(fileSet.getLineEnding());
            File tmpDir = null;
            if (lineEnding != null) {
                tmpDir = FileUtils.createTempFile((String)"", (String)"", (File)this.tempRoot);
                tmpDir.mkdirs();
            }
            archiver.setDefaultDirectoryMode(Integer.parseInt(fileSet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(fileSet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("FileSet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding())));
            if (directory == null) {
                directory = this.basedir.getAbsolutePath();
                if (output == null) {
                    output = "";
                }
            } else if (output == null) {
                output = directory;
            }
            output = this.getOutputDirectory(output, this.project, includeBaseDirecetory);
            String[] includes = fileSet.getIncludes().toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            if (includes.length == 0) {
                includes = null;
            }
            List excludesList = fileSet.getExcludes();
            excludesList.addAll(FileUtils.getDefaultExcludesAsList());
            String[] excludes = excludesList.toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            if (this.archiveBaseDirectory == null) {
                archiveBaseDir = new File(directory);
            } else {
                if (!this.archiveBaseDirectory.exists()) {
                    throw new MojoFailureException("The archive base directory '" + this.archiveBaseDirectory.getAbsolutePath() + "' does not exist");
                }
                if (!this.archiveBaseDirectory.isDirectory()) {
                    throw new MojoFailureException("The archive base directory '" + this.archiveBaseDirectory.getAbsolutePath() + "' exists, but it is not a directory");
                }
                archiveBaseDir = new File(this.archiveBaseDirectory, directory);
            }
            this.getLog().debug((CharSequence)("The archive base directory is '" + archiveBaseDir.getAbsolutePath() + "'"));
            if (!archiveBaseDir.isAbsolute()) {
                archiveBaseDir = new File(this.basedir, directory);
            }
            if (!archiveBaseDir.exists()) continue;
            if (lineEnding != null) {
                this.copySetReplacingLineEndings(archiveBaseDir, tmpDir, includes, excludes, lineEnding);
                archiveBaseDir = tmpDir;
            }
            this.getLog().debug((CharSequence)("Archive base directory: '" + archiveBaseDir.getAbsolutePath() + "'"));
            this.addDirectory(archiver, archiveBaseDir, output, includes, excludesList);
        }
    }

    protected void processFileList(Archiver archiver, List fileList, boolean includeBaseDirecetory) throws MojoExecutionException, MojoFailureException {
        String sourceFileItem = null;
        Iterator i = fileList.iterator();
        while (i.hasNext()) {
            String lineEnding;
            String destName;
            FileItem fileItem = (FileItem)i.next();
            if (fileItem.isFiltered()) {
                sourceFileItem = fileItem.getSource();
                File filteredFile = this.filterFile(new File(sourceFileItem));
                fileItem.setSource(filteredFile.getAbsolutePath());
            }
            String outputDirectory = fileItem.getOutputDirectory();
            File source = new File(fileItem.getSource());
            if (outputDirectory == null) {
                outputDirectory = "";
            }
            if ((destName = fileItem.getDestName()) == null) {
                destName = source.getName();
            }
            if ((lineEnding = AbstractAssemblyMojo.getLineEndingCharacters(fileItem.getLineEnding())) != null) {
                try {
                    if (!this.tempRoot.exists()) {
                        this.tempRoot.mkdirs();
                    }
                    File tempRootFile = File.createTempFile(source.getName() + ".", "", this.tempRoot);
                    tempRootFile.deleteOnExit();
                    this.copyReplacingLineEndings(source, tempRootFile, lineEnding);
                    source = tempRootFile;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error replacing line endings: " + e.getMessage(), (Exception)e);
                }
            }
            if ((outputDirectory = this.getOutputDirectory(outputDirectory, this.project, includeBaseDirecetory)).endsWith("/") || outputDirectory.endsWith("\\")) {
                outputDirectory = outputDirectory.substring(0, outputDirectory.length() - 1);
            }
            try {
                archiver.addFile(source, outputDirectory + "/" + destName, Integer.parseInt(fileItem.getFileMode()));
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding file to archive: " + e.getMessage(), (Exception)((Object)e));
            }
            if (!fileItem.isFiltered()) continue;
            fileItem.setSource(sourceFileItem);
        }
    }

    private static String evaluateFileNameMapping(String expression, Artifact artifact) throws MojoExecutionException {
        String value = expression;
        Pattern pat = Pattern.compile("^(.*)\\$\\{([^\\}]+)\\}(.*)$");
        Matcher mat = pat.matcher(expression);
        if (mat.matches()) {
            Object middle;
            String left = AbstractAssemblyMojo.evaluateFileNameMapping(mat.group(1), artifact);
            try {
                middle = ReflectionValueExtractor.evaluate((String)mat.group(2), (Object)artifact, (boolean)false);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot evaluate filenameMapping: '" + mat.group(1) + "': " + e.getMessage(), e);
            }
            String right = mat.group(3);
            if (middle == null) {
                if ("extension".equals(mat.group(2).trim())) {
                    ArtifactHandler artifactHandler = artifact.getArtifactHandler();
                    middle = artifactHandler.getExtension();
                } else {
                    middle = "${" + mat.group(2) + "}";
                }
            }
            value = left + middle + right;
        }
        return value;
    }

    private String getOutputDirectory(String output, MavenProject project, boolean includeBaseDirectory) {
        String value = output;
        if (value == null) {
            value = "";
        }
        if (!value.endsWith("/") && !value.endsWith("\\")) {
            value = value + '/';
        }
        if (includeBaseDirectory) {
            value = value.startsWith("/") ? this.finalName + value : this.finalName + "/" + value;
        } else if (value.startsWith("/")) {
            value = value.substring(1);
        }
        if (project != null) {
            value = StringUtils.replace((String)value, (String)"${groupId}", (String)project.getGroupId());
            value = StringUtils.replace((String)value, (String)"${artifactId}", (String)project.getArtifactId());
            value = StringUtils.replace((String)value, (String)"${version}", (String)project.getVersion());
            Build build = project.getBuild();
            value = StringUtils.replace((String)value, (String)"${build.finalName}", (String)build.getFinalName());
            value = StringUtils.replace((String)value, (String)"${finalName}", (String)build.getFinalName());
        }
        return value;
    }

    private Archiver createArchiver(String format) throws ArchiverException, NoSuchArchiverException {
        TarArchiver archiver;
        if (format.startsWith("tar")) {
            TarArchiver tarArchiver;
            archiver = tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
            int index = format.indexOf(46);
            if (index >= 0) {
                TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
                String compression = format.substring(index + 1);
                if ("gz".equals(compression)) {
                    tarCompressionMethod.setValue("gzip");
                } else if ("bz2".equals(compression)) {
                    tarCompressionMethod.setValue("bzip2");
                } else {
                    throw new IllegalArgumentException("Unknown compression format: " + compression);
                }
                tarArchiver.setCompression(tarCompressionMethod);
                TarLongFileMode tarFileMode = new TarLongFileMode();
                tarFileMode.setValue(this.tarLongFileMode);
                tarArchiver.setLongfile(tarFileMode);
            }
        } else if ("war".equals(format)) {
            WarArchiver warArchiver = (WarArchiver)this.archiverManager.getArchiver("war");
            warArchiver.setIgnoreWebxml(false);
            archiver = warArchiver;
        } else {
            archiver = this.archiverManager.getArchiver(format);
        }
        return archiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReplacingLineEndings(File source, File dest, String lineEndings) throws IOException {
        this.getLog().debug((CharSequence)("Copying while replacing line endings: " + source + " to " + dest));
        BufferedReader in = new BufferedReader(new FileReader(source));
        BufferedWriter out = null;
        try {
            String line;
            out = new BufferedWriter(new FileWriter(dest));
            do {
                if ((line = in.readLine()) == null) continue;
                out.write(line);
                out.write(lineEndings);
            } while (line != null);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            IOUtil.close((Reader)in);
            throw throwable;
        }
        IOUtil.close((Writer)out);
        IOUtil.close((Reader)in);
    }

    private void copySetReplacingLineEndings(File archiveBaseDir, File tmpDir, String[] includes, String[] excludes, String lineEnding) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(archiveBaseDir.getAbsolutePath());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(this.tempRoot, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File targetFile = new File(tmpDir, files[j]);
            try {
                targetFile.getParentFile().mkdirs();
                this.copyReplacingLineEndings(new File(archiveBaseDir, files[j]), targetFile, lineEnding);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    private static String getLineEndingCharacters(String lineEnding) throws MojoFailureException {
        String value = lineEnding;
        if (lineEnding != null) {
            if ("keep".equals(lineEnding)) {
                value = null;
            } else if ("dos".equals(lineEnding) || "crlf".equals(lineEnding)) {
                value = "\r\n";
            } else if ("unix".equals(lineEnding) || "lf".equals(lineEnding)) {
                value = "\n";
            } else {
                throw new MojoFailureException("Illlegal lineEnding specified: '" + lineEnding + "'");
            }
        }
        return value;
    }

    private void includeSiteInAssembly(Assembly assembly) throws MojoFailureException {
        if (!this.siteDirectory.exists()) {
            throw new MojoFailureException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLog().info((CharSequence)("Adding site directory to assembly : " + this.siteDirectory));
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(this.siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }

    private void initializeFiltering() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Initializing assembly filters...");
        this.filterProperties = new Properties(System.getProperties());
        ((Hashtable)this.filterProperties).putAll(this.project.getProperties());
        if (this.filters != null && !this.filters.isEmpty()) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                String filtersfile = (String)i.next();
                try {
                    Properties properties = PropertyUtils.loadPropertyFile(new File(filtersfile), true, true);
                    ((Hashtable)this.filterProperties).putAll(properties);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error loading property file '" + filtersfile + "'", (Exception)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File filterFile(File file) throws MojoExecutionException {
        this.initializeFiltering();
        File tempFilterFile = new File(this.tempRoot + "/" + file.getName());
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(file));
            boolean isPropertiesFile = false;
            if (file.isFile() && file.getName().endsWith(".properties")) {
                isPropertiesFile = true;
            }
            tempFilterFile.getParentFile().mkdirs();
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)fileReader, (Map)this.filterProperties, "${", "}");
            BufferedReader in = new BufferedReader((Reader)new InterpolationFilterReader((Reader)reader, (Map)new ReflectionProperties(this.project, isPropertiesFile), "${", "}"));
            FileWriter fileWriter = null;
            try {
                String line;
                fileWriter = new FileWriter(tempFilterFile);
                while ((line = in.readLine()) != null) {
                    fileWriter.write(line);
                    fileWriter.write(LS);
                }
                ((Writer)fileWriter).flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Writer)fileWriter);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("File to filter not found: " + e.getMessage(), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error filtering file '" + file + "': " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        return tempFilterFile;
    }
}

