/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforcerRuleUtils {
    ArtifactFactory factory;
    ArtifactResolver resolver;
    ArtifactRepository local;
    List<ArtifactRepository> remoteRepositories;
    Log log;
    MavenProject project;
    private EnforcerRuleHelper helper;

    public EnforcerRuleUtils(ArtifactFactory theFactory, ArtifactResolver theResolver, ArtifactRepository theLocal, List<ArtifactRepository> theRemoteRepositories, MavenProject project, Log theLog) {
        this.factory = theFactory;
        this.resolver = theResolver;
        this.local = theLocal;
        this.remoteRepositories = theRemoteRepositories;
        this.log = theLog;
        this.project = project;
    }

    public EnforcerRuleUtils(EnforcerRuleHelper helper) {
        this.helper = helper;
        try {
            this.factory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            this.resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            this.local = (ArtifactRepository)helper.evaluate("${localRepository}");
            this.project = (MavenProject)helper.evaluate("${project}");
            this.remoteRepositories = this.project.getRemoteArtifactRepositories();
        }
        catch (ComponentLookupException e) {
            e.printStackTrace();
        }
        catch (ExpressionEvaluationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model readModel(File pom) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)pom);
        MavenXpp3Reader xpp3 = new MavenXpp3Reader();
        Model model = null;
        try {
            model = xpp3.read((Reader)reader);
        }
        finally {
            reader.close();
            reader = null;
        }
        return model;
    }

    private Model getPomModel(String groupId, String artifactId, String version, File pom) throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        Model model = null;
        boolean found = false;
        try {
            model = this.readModel(pom);
            found = this.checkIfModelMatches(groupId, artifactId, version, model);
        }
        catch (IOException e) {
        }
        catch (XmlPullParserException e) {
            // empty catch block
        }
        if (!found) {
            Artifact pomArtifact = this.factory.createArtifact(groupId, artifactId, version, null, "pom");
            this.resolver.resolve(pomArtifact, this.remoteRepositories, this.local);
            model = this.readModel(pomArtifact.getFile());
        }
        return model;
    }

    public List<Model> getModelsRecursively(String groupId, String artifactId, String version, File pom) throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        List<Model> models = null;
        Model model = this.getPomModel(groupId, artifactId, version, pom);
        Parent parent = model.getParent();
        if (parent != null) {
            File parentPom;
            String relativePath = parent.getRelativePath();
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = "../pom.xml";
            }
            if ((parentPom = new File(pom.getParent(), relativePath)).isDirectory()) {
                parentPom = new File(parentPom, "pom.xml");
            }
            models = this.getModelsRecursively(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), parentPom);
        } else {
            models = new ArrayList<Model>();
        }
        models.add(model);
        return models;
    }

    protected boolean checkIfModelMatches(String groupId, String artifactId, String version, Model model) {
        String modelGroup = model.getGroupId();
        String modelVersion = model.getVersion();
        try {
            modelGroup = StringUtils.isEmpty((String)modelGroup) ? model.getParent().getGroupId() : (String)this.helper.evaluate(modelGroup);
            modelVersion = StringUtils.isEmpty((String)modelVersion) ? model.getParent().getVersion() : (String)this.helper.evaluate(modelVersion);
        }
        catch (NullPointerException e) {
        }
        catch (ExpressionEvaluationException e) {
            // empty catch block
        }
        return StringUtils.equals((String)groupId, (String)modelGroup) && StringUtils.equals((String)version, (String)modelVersion) && StringUtils.equals((String)artifactId, (String)model.getArtifactId());
    }
}

