/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireUpperBoundDeps
extends AbstractNonCacheableEnforcerRule {
    private static Log log;
    private static I18N i18n;

    private DependencyNode getNode(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            DependencyTreeBuilder dependencyTreeBuilder = (DependencyTreeBuilder)helper.getComponent(DependencyTreeBuilder.class);
            ArtifactRepository repository = (ArtifactRepository)helper.evaluate("${localRepository}");
            ArtifactFactory factory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            ArtifactMetadataSource metadataSource = (ArtifactMetadataSource)helper.getComponent(ArtifactMetadataSource.class);
            ArtifactCollector collector = (ArtifactCollector)helper.getComponent(ArtifactCollector.class);
            ArtifactFilter filter = null;
            DependencyNode node = dependencyTreeBuilder.buildDependencyTree(project, repository, factory, metadataSource, filter, collector);
            return node;
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (DependencyTreeBuilderException e) {
            throw new EnforcerRuleException("Could not build dependency tree " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (log == null) {
            log = helper.getLog();
        }
        try {
            if (i18n == null) {
                i18n = (I18N)helper.getComponent(I18N.class);
            }
            DependencyNode node = this.getNode(helper);
            RequireUpperBoundDepsVisitor visitor = new RequireUpperBoundDepsVisitor();
            node.accept((DependencyNodeVisitor)visitor);
            List<String> errorMessages = this.buildErrorMessages(visitor.getConflicts());
            if (errorMessages.size() > 0) {
                throw new EnforcerRuleException("Failed while enforcing RequireUpperBoundDeps. The error(s) are " + errorMessages);
            }
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new EnforcerRuleException(e.getLocalizedMessage(), e);
        }
    }

    private List<String> buildErrorMessages(List<List<DependencyNode>> conflicts) {
        ArrayList<String> errorMessages = new ArrayList<String>(conflicts.size());
        for (List<DependencyNode> conflict : conflicts) {
            errorMessages.add(this.buildErrorMessage(conflict));
        }
        return errorMessages;
    }

    private String buildErrorMessage(List<DependencyNode> conflict) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("\nRequire upper bound dependencies error for " + this.getFullArtifactName(conflict.get(0).getArtifact()) + " paths to dependency are:\n");
        if (conflict.size() > 0) {
            errorMessage.append((CharSequence)this.buildTreeString(conflict.get(0)));
        }
        for (DependencyNode node : conflict.subList(1, conflict.size())) {
            errorMessage.append("and\n");
            errorMessage.append((CharSequence)this.buildTreeString(node));
        }
        return errorMessage.toString();
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        for (DependencyNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            loc.add(this.getFullArtifactName(currentNode.getArtifact()));
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-").append((String)loc.get(i));
            builder.append("\n");
        }
        return builder;
    }

    private String getFullArtifactName(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyNodeHopCountPair
    implements Comparable<DependencyNodeHopCountPair> {
        private DependencyNode node;
        private int hopCount;

        private DependencyNodeHopCountPair(DependencyNode node) {
            this.node = node;
            this.countHops();
        }

        private void countHops() {
            this.hopCount = 0;
            for (DependencyNode parent = this.node.getParent(); parent != null; parent = parent.getParent()) {
                ++this.hopCount;
            }
        }

        private String constructKey() {
            Artifact artifact = this.node.getArtifact();
            return artifact.getGroupId() + ":" + artifact.getArtifactId();
        }

        public DependencyNode getNode() {
            return this.node;
        }

        private ArtifactVersion extractArtifactVersion() {
            Artifact artifact = this.node.getArtifact();
            String version = artifact.getVersion();
            if (version != null) {
                return new DefaultArtifactVersion(version);
            }
            try {
                return artifact.getSelectedVersion();
            }
            catch (OverConstrainedVersionException e) {
                throw new RuntimeException("Version ranges problem with " + this.node.getArtifact(), e);
            }
        }

        public int getHopCount() {
            return this.hopCount;
        }

        @Override
        public int compareTo(DependencyNodeHopCountPair other) {
            return Integer.valueOf(this.hopCount).compareTo(other.getHopCount());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequireUpperBoundDepsVisitor
    implements DependencyNodeVisitor {
        private Map<String, List<DependencyNodeHopCountPair>> keyToPairsMap = new LinkedHashMap<String, List<DependencyNodeHopCountPair>>();

        private RequireUpperBoundDepsVisitor() {
        }

        public boolean visit(DependencyNode node) {
            DependencyNodeHopCountPair pair = new DependencyNodeHopCountPair(node);
            String key = pair.constructKey();
            List<DependencyNodeHopCountPair> pairs = this.keyToPairsMap.get(key);
            if (pairs == null) {
                pairs = new ArrayList<DependencyNodeHopCountPair>();
                this.keyToPairsMap.put(key, pairs);
            }
            pairs.add(pair);
            Collections.sort(pairs);
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            return true;
        }

        public List<List<DependencyNode>> getConflicts() {
            ArrayList<List<DependencyNode>> output = new ArrayList<List<DependencyNode>>();
            for (List<DependencyNodeHopCountPair> pairs : this.keyToPairsMap.values()) {
                if (!this.containsConflicts(pairs)) continue;
                ArrayList<DependencyNode> outputSubList = new ArrayList<DependencyNode>(pairs.size());
                for (DependencyNodeHopCountPair pair : pairs) {
                    outputSubList.add(pair.getNode());
                }
                output.add(outputSubList);
            }
            return output;
        }

        private boolean containsConflicts(List<DependencyNodeHopCountPair> pairs) {
            ArtifactVersion resolvedVersion = pairs.get(0).extractArtifactVersion();
            for (DependencyNodeHopCountPair pair : pairs) {
                ArtifactVersion version = pair.extractArtifactVersion();
                if (resolvedVersion.compareTo((Object)version) >= 0) continue;
                return true;
            }
            return false;
        }
    }
}

