/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireNoRepositories
extends AbstractNonCacheableEnforcerRule {
    public boolean banRepositories = true;
    public boolean banPluginRepositories = true;
    public List<String> allowedRepositories = Collections.emptyList();
    public List<String> allowedPluginRepositories = Collections.emptyList();
    public boolean allowSnapshotRepositories = false;
    public boolean allowSnapshotPluginRepositories = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerRuleUtils utils = new EnforcerRuleUtils(helper);
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List<Model> models = utils.getModelsRecursively(project.getGroupId(), project.getArtifactId(), project.getVersion(), new File(project.getBasedir(), "pom.xml"));
            ArrayList<Model> badModels = new ArrayList<Model>();
            StringBuffer newMsg = new StringBuffer();
            newMsg.append("Some poms have repositories defined:\n");
            for (Model model : models) {
                List<String> bannedRepos;
                List repos;
                if (this.banRepositories && (repos = model.getRepositories()) != null && !repos.isEmpty() && !(bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedRepositories, this.allowSnapshotRepositories)).isEmpty()) {
                    badModels.add(model);
                    newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has repositories " + bannedRepos);
                }
                if (!this.banPluginRepositories || (repos = model.getPluginRepositories()) == null || repos.isEmpty() || (bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedPluginRepositories, this.allowSnapshotPluginRepositories)).isEmpty()) continue;
                badModels.add(model);
                newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has plugin repositories " + bannedRepos);
            }
            if (!badModels.isEmpty()) {
                if (StringUtils.isNotEmpty((String)this.message)) {
                    newMsg.append(this.message);
                }
                throw new EnforcerRuleException(newMsg.toString());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (XmlPullParserException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
    }

    private static List<String> findBannedRepositories(List<Repository> repos, List<String> allowedRepos, boolean allowSnapshots) {
        ArrayList<String> bannedRepos = new ArrayList<String>(allowedRepos.size());
        for (Repository r : repos) {
            if (allowedRepos.contains(r.getId()) || allowSnapshots && !r.getReleases().isEnabled()) continue;
            bannedRepos.add(r.getId());
        }
        return bannedRepos;
    }
}

