/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.CellTokenStream;
import org.apache.lucene.spatial.prefix.PointPrefixTreeFieldCacheProvider;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.ShapeFieldCacheDistanceValueSource;

public abstract class PrefixTreeStrategy
extends SpatialStrategy {
    protected final SpatialPrefixTree grid;
    private final Map<String, PointPrefixTreeFieldCacheProvider> provider = new ConcurrentHashMap<String, PointPrefixTreeFieldCacheProvider>();
    protected int defaultFieldValuesArrayLen = 2;
    protected double distErrPct = 0.025;
    public static final FieldType FIELD_TYPE = new FieldType();

    public PrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid.getSpatialContext(), fieldName);
        this.grid = grid;
    }

    public void setDefaultFieldValuesArrayLen(int defaultFieldValuesArrayLen) {
        this.defaultFieldValuesArrayLen = defaultFieldValuesArrayLen;
    }

    public double getDistErrPct() {
        return this.distErrPct;
    }

    public void setDistErrPct(double distErrPct) {
        this.distErrPct = distErrPct;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        double distErr = SpatialArgs.calcDistanceFromErrPct(shape, this.distErrPct, this.ctx);
        return this.createIndexableFields(shape, distErr);
    }

    public Field[] createIndexableFields(Shape shape, double distErr) {
        int detailLevel = this.grid.getLevelForDistance(distErr);
        TokenStream tokenStream = this.createTokenStream(shape, detailLevel);
        Field field = new Field(this.getFieldName(), tokenStream, FIELD_TYPE);
        return new Field[]{field};
    }

    protected TokenStream createTokenStream(Shape shape, int detailLevel) {
        CellIterator cells = this.grid.getTreeCellIterator(shape, detailLevel);
        return new CellTokenStream().setCells(cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        PointPrefixTreeFieldCacheProvider p = this.provider.get(this.getFieldName());
        if (p == null) {
            PrefixTreeStrategy prefixTreeStrategy = this;
            synchronized (prefixTreeStrategy) {
                p = this.provider.get(this.getFieldName());
                if (p == null) {
                    p = new PointPrefixTreeFieldCacheProvider(this.grid, this.getFieldName(), this.defaultFieldValuesArrayLen);
                    this.provider.put(this.getFieldName(), p);
                }
            }
        }
        return new ShapeFieldCacheDistanceValueSource(this.ctx, p, queryPoint, multiplier);
    }

    public SpatialPrefixTree getGrid() {
        return this.grid;
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }
}

