/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.spatial.prefix.tree.Node;

public abstract class SpatialPrefixTree {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final int maxLevels;
    protected final SpatialContext ctx;
    private transient Node worldNode;

    public SpatialPrefixTree(SpatialContext ctx, int maxLevels) {
        assert (maxLevels > 0);
        this.ctx = ctx;
        this.maxLevels = maxLevels;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ")";
    }

    public abstract int getLevelForDistance(double var1);

    public Node getWorldNode() {
        if (this.worldNode == null) {
            this.worldNode = this.getNode("");
        }
        return this.worldNode;
    }

    public abstract Node getNode(String var1);

    public abstract Node getNode(byte[] var1, int var2, int var3);

    public final Node getNode(byte[] bytes, int offset, int len, Node target) {
        if (target == null) {
            return this.getNode(bytes, offset, len);
        }
        target.reset(bytes, offset, len);
        return target;
    }

    protected Node getNode(Point p, int level) {
        return this.getNodes((Shape)p, level, false).get(0);
    }

    public List<Node> getNodes(Shape shape, int detailLevel, boolean inclParents) {
        ArrayList<Node> cells;
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel > maxLevels");
        }
        if (shape instanceof Point) {
            int initialCapacity = inclParents ? 1 + detailLevel : 1;
            cells = new ArrayList(initialCapacity);
            this.recursiveGetNodes(this.getWorldNode(), (Point)shape, detailLevel, true, cells);
            assert (cells.size() == initialCapacity);
        } else {
            cells = new ArrayList<Node>(inclParents ? 1024 : 512);
            this.recursiveGetNodes(this.getWorldNode(), shape, detailLevel, inclParents, cells);
        }
        if (inclParents) {
            Node c = (Node)cells.remove(0);
            assert (c.getLevel() == 0);
        }
        return cells;
    }

    private void recursiveGetNodes(Node node, Shape shape, int detailLevel, boolean inclParents, Collection<Node> result) {
        if (node.isLeaf()) {
            result.add(node);
            return;
        }
        Collection<Node> subCells = node.getSubCells(shape);
        if (node.getLevel() == detailLevel - 1) {
            if (subCells.size() < node.getSubCellsSize() || node.getLevel() == 0) {
                if (inclParents) {
                    result.add(node);
                }
                for (Node subCell : subCells) {
                    subCell.setLeaf();
                }
                result.addAll(subCells);
            } else {
                node.setLeaf();
                result.add(node);
            }
        } else {
            if (inclParents) {
                result.add(node);
            }
            for (Node subCell : subCells) {
                this.recursiveGetNodes(subCell, shape, detailLevel, inclParents, result);
            }
        }
    }

    private void recursiveGetNodes(Node node, Point point, int detailLevel, boolean inclParents, Collection<Node> result) {
        if (inclParents) {
            result.add(node);
        }
        Node pCell = node.getSubCell(point);
        if (node.getLevel() == detailLevel - 1) {
            pCell.setLeaf();
            result.add(pCell);
        } else {
            this.recursiveGetNodes(pCell, point, detailLevel, inclParents, result);
        }
    }

    protected final List<Node> getNodesAltPoint(Point p, int detailLevel, boolean inclParents) {
        Node cell = this.getNode(p, detailLevel);
        if (!inclParents) {
            return Collections.singletonList(cell);
        }
        String endToken = cell.getTokenString();
        assert (endToken.length() == detailLevel);
        ArrayList<Node> cells = new ArrayList<Node>(detailLevel);
        for (int i = 1; i < detailLevel; ++i) {
            cells.add(this.getNode(endToken.substring(0, i)));
        }
        cells.add(cell);
        return cells;
    }

    public static List<String> nodesToTokenStrings(Collection<Node> nodes) {
        ArrayList<String> tokens = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            String token = node.getTokenString();
            if (node.isLeaf()) {
                tokens.add(token + '+');
                continue;
            }
            tokens.add(token);
        }
        return tokens;
    }
}

