/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.util.CachingDoubleValueSource;
import org.apache.lucene.spatial.util.ValueSourceFilter;
import org.apache.lucene.spatial.vector.DistanceValueSource;

public class TwoDoublesStrategy
extends SpatialStrategy {
    public static final String SUFFIX_X = "__x";
    public static final String SUFFIX_Y = "__y";
    private final String fieldNameX;
    private final String fieldNameY;
    public int precisionStep = 8;

    public TwoDoublesStrategy(SpatialContext ctx, String fieldNamePrefix) {
        super(ctx, fieldNamePrefix);
        this.fieldNameX = fieldNamePrefix + SUFFIX_X;
        this.fieldNameY = fieldNamePrefix + SUFFIX_Y;
    }

    public void setPrecisionStep(int p) {
        this.precisionStep = p;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
    }

    String getFieldNameX() {
        return this.fieldNameX;
    }

    String getFieldNameY() {
        return this.fieldNameY;
    }

    @Override
    public IndexableField[] createIndexableFields(Shape shape) {
        if (shape instanceof Point) {
            Point point = (Point)shape;
            FieldType doubleFieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
            doubleFieldType.setNumericPrecisionStep(this.precisionStep);
            IndexableField[] f = new IndexableField[]{new DoubleField(this.fieldNameX, point.getX(), doubleFieldType), new DoubleField(this.fieldNameY, point.getY(), doubleFieldType)};
            return f;
        }
        if (!this.ignoreIncompatibleGeometry) {
            throw new IllegalArgumentException("TwoDoublesStrategy can not index: " + shape);
        }
        return new IndexableField[0];
    }

    @Override
    public ValueSource makeValueSource(SpatialArgs args) {
        Point p = args.getShape().getCenter();
        return new DistanceValueSource(this, p, this.ctx.getDistCalc());
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        if (args.getShape() instanceof Circle && SpatialOperation.is(args.getOperation(), SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            Circle circle = (Circle)args.getShape();
            Query bbox = this.makeWithin(circle.getBoundingBox());
            ValueSource valueSource = this.makeValueSource(args);
            return new ValueSourceFilter((Filter)new QueryWrapperFilter(bbox), valueSource, 0.0, circle.getDistance());
        }
        return new QueryWrapperFilter(this.makeQuery(args));
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle) && !(shape instanceof Circle)) {
            throw new InvalidShapeException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
        }
        Rectangle bbox = shape.getBoundingBox();
        if (bbox.getCrossesDateLine()) {
            throw new UnsupportedOperationException("Crossing dateline not yet supported");
        }
        ValueSource valueSource = null;
        Query spatial = null;
        SpatialOperation op = args.getOperation();
        if (SpatialOperation.is(op, SpatialOperation.BBoxWithin, SpatialOperation.BBoxIntersects)) {
            spatial = this.makeWithin(bbox);
        } else if (SpatialOperation.is(op, SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            spatial = this.makeWithin(bbox);
            if (args.getShape() instanceof Circle) {
                Circle circle = (Circle)args.getShape();
                valueSource = this.makeValueSource(args);
                ValueSourceFilter vsf = new ValueSourceFilter((Filter)new QueryWrapperFilter(spatial), valueSource, 0.0, circle.getDistance());
                spatial = new FilteredQuery((Query)new MatchAllDocsQuery(), (Filter)vsf);
            }
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox);
        }
        if (spatial == null) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        valueSource = valueSource != null ? new CachingDoubleValueSource(valueSource) : this.makeValueSource(args);
        FunctionQuery spatialRankingQuery = new FunctionQuery(valueSource);
        BooleanQuery bq = new BooleanQuery();
        bq.add(spatial, BooleanClause.Occur.MUST);
        bq.add((Query)spatialRankingQuery, BooleanClause.Occur.MUST);
        return bq;
    }

    private Query makeWithin(Rectangle bbox) {
        NumericRangeQuery qX = NumericRangeQuery.newDoubleRange((String)this.fieldNameX, (int)this.precisionStep, (Double)bbox.getMinX(), (Double)bbox.getMaxX(), (boolean)true, (boolean)true);
        NumericRangeQuery qY = NumericRangeQuery.newDoubleRange((String)this.fieldNameY, (int)this.precisionStep, (Double)bbox.getMinY(), (Double)bbox.getMaxY(), (boolean)true, (boolean)true);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)qX, BooleanClause.Occur.MUST);
        bq.add((Query)qY, BooleanClause.Occur.MUST);
        return bq;
    }

    Query makeDisjoint(Rectangle bbox) {
        NumericRangeQuery qX = NumericRangeQuery.newDoubleRange((String)this.fieldNameX, (int)this.precisionStep, (Double)bbox.getMinX(), (Double)bbox.getMaxX(), (boolean)true, (boolean)true);
        NumericRangeQuery qY = NumericRangeQuery.newDoubleRange((String)this.fieldNameY, (int)this.precisionStep, (Double)bbox.getMinY(), (Double)bbox.getMaxY(), (boolean)true, (boolean)true);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)qX, BooleanClause.Occur.MUST_NOT);
        bq.add((Query)qY, BooleanClause.Occur.MUST_NOT);
        return bq;
    }
}

